<?php
session_start();
include("connect.php");

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: login.php");
    exit;
}

/*
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
*/

$phone_number = $_SESSION["phone_number"];
$message = "";
$message_type = "";

// Fetch user data
$user_query = mysqli_query($con, "SELECT * FROM members WHERE phone_number='$phone_number'");
$user = mysqli_fetch_assoc($user_query);

$earning_wallet = $user['earning_wallet'];


// Fetch pin data
$pin_query = mysqli_query($con, "SELECT * FROM withdraw_pins WHERE phone_number='$phone_number'");
$pin_data = mysqli_fetch_assoc($pin_query);
$withdraw_pin = $pin_data['pin']; // Assume this is stored hashed



// Handle new PIN setup
if (isset($_POST['set_pin'])) {
    $new_pin = trim($_POST['new_pin']);
    if (preg_match('/^\d{4}$/', $new_pin)) {
        $hashed_pin = password_hash($new_pin, PASSWORD_DEFAULT);
       // First-time PIN setup - INSERT into withdraw_pins table
$hashed_pin = password_hash($new_pin, PASSWORD_DEFAULT);
$insert_pin = mysqli_query($con, "INSERT INTO withdraw_pins (phone_number, pin) VALUES ('$phone_number', '$hashed_pin')");

if ($insert_pin) {
   // echo json_encode(['status' => 'success', 'message' => 'Withdrawal PIN set successfully.']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to set withdrawal PIN. Please try again.']);
}

        $message = "Withdrawal PIN set successfully.";
        $message_type = "success";
        $withdraw_pin = $hashed_pin;
    } else {
        $message = "PIN must be a 4-digit number.";
        $message_type = "error";
    }
}

// Handle PIN reset
if (isset($_POST['reset_pin'])) {
    $account_password = $_POST['account_password'];
    if (password_verify($account_password, $user['password'])) {
        $new_pin = trim($_POST['reset_new_pin']);
        if (preg_match('/^\d{4}$/', $new_pin)) {
            $hashed_new_pin = password_hash($new_pin, PASSWORD_DEFAULT);
            mysqli_query($con, "UPDATE withdraw_pins SET pin='$hashed_new_pin' WHERE phone_number='$phone_number'");
            $message = "Withdrawal PIN reset successfully.";
            $message_type = "success";
            $withdraw_pin = $hashed_new_pin;
        } else {
            $message = "PIN must be a 4-digit number.";
            $message_type = "error";
        }
    } else {
        $message = "Incorrect account password.";
        $message_type = "error";
    }
}

// Handle withdrawal request
// Handle withdrawal request
if (isset($_POST['request_withdrawal'])) {
    $amount = floatval($_POST['amount']);
    $bank_name = mysqli_real_escape_string($con, $_POST['bank_name']);
    $account_number = mysqli_real_escape_string($con, $_POST['account_number']);
    $account_name = mysqli_real_escape_string($con, $_POST['account_name']);
    $entered_pin = $_POST['withdraw_pin'];

    // Get hashed pin from DB again to make sure it's current
    $pin_check_query = mysqli_query($con, "SELECT pin FROM withdraw_pins WHERE phone_number = '$phone_number'");
    $pin_data = mysqli_fetch_assoc($pin_check_query);
    $stored_pin_hash = $pin_data['pin'] ?? '';

    if (!password_verify($entered_pin, $stored_pin_hash)) {
        $message = "Incorrect withdrawal PIN.";
        $message_type = "error";
    } elseif ($amount <= 0 || $amount > $earning_wallet) {
        $message = "Insufficient balance or invalid amount.";
        $message_type = "error";
    } else {
        $date = date("Y-m-d H:i:s");
        $insert = mysqli_query($con, "INSERT INTO withdrawal_requests (phone_number, bank_name, account_number, account_name, amount, status, request_date)
                    VALUES ('$phone_number', '$bank_name', '$account_number', '$account_name', '$amount', 'pending', '$date')");

        if ($insert) {
            $update = mysqli_query($con, "UPDATE members SET earning_wallet = earning_wallet - $amount WHERE phone_number = '$phone_number'");

            if ($update) {
                $message = "Withdrawal request submitted successfully.";
                $message_type = "success";
            } else {
                $message = "Withdrawal request saved, but failed to update wallet.";
                $message_type = "error";
            }
        } else {
            $message = "Failed to submit request. " . mysqli_error($con); // Shows exact error
            $message_type = "error";
        }
    }
}

?>



<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Withdraw Funds</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
 /* Global box-sizing for consistent sizing */
*, *::before, *::after {
  box-sizing: border-box;
}

body {
    margin: 0;
    font-family: 'Segoe UI', sans-serif;
    background: #1c1c1c; /* very dark gray/black background */
    color: #ddd; /* light gray text for readability */
}

header, footer {
    background: linear-gradient(135deg, black, #805c00); /* rich gold gradient */
    color: white; /* light text for contrast */
    text-align: center;
    padding: 20px 15px;
    font-weight: 700;
    letter-spacing: 1px;
    text-shadow: 0 0 5px rgba(0,0,0,0.3);
    box-shadow: 0 3px 6px rgba(0,0,0,0.5);
}

.container {
    max-width: 600px;
    margin: 40px auto;
    padding: 30px 20px; /* reduced horizontal padding */
    background: #2e2e2e; /* dark gray container */
    border-radius: 12px;
    box-shadow: 0 0 20px rgba(191,160,74,0.6); /* soft golden glow */
    color: #eee;
    overflow-x: hidden; /* prevent horizontal scroll */
}

h2 {
    text-align: center;
    color: #d4af37; /* gold color */
    
    margin-bottom: 25px;
}

/* Amount options container with responsive grid */
.amount-options {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(100px, 1fr)); /* flexible columns */
    gap: 10px;
}

/* 3 columns explicitly on small screens */
@media (max-width: 600px) {
    .amount-options {
        grid-template-columns: repeat(3, 1fr);
    }
}

.amount-options button {
    width: 100%;
    max-width: 100%;
    padding: 10px 10px;
    background: linear-gradient(145deg, black, #a67c00);
    color: white;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    font-weight: 600;
    box-shadow: 0 3px 6px rgba(166,124,0,0.6);
    transition: background 0.3s ease, transform 0.2s ease;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}
.amount-options button:hover {
    background: linear-gradient(145deg, #a67c00, #d4af37);
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(166,124,0,0.8);
}

input, select {
    width: 100%;
    padding: 14px;
    margin: 10px 0 24px;
    border-radius: 8px;
    border: 1.5px solid #bfa04a;
    background: #444; /* dark input background */
    color: #eee;
    font-weight: 600;
    box-shadow: inset 0 0 6px rgba(191,160,74,0.4);
    transition: border-color 0.3s ease;
}

input:focus, select:focus {
    border-color: #d4af37;
    outline: none;
    box-shadow: 0 0 8px #d4af37;
    background: #555;
    color: #fff;
}

button.submit-btn {
    width: 100%;
    padding: 16px;
    background: linear-gradient(135deg, black, #805c00);
    color: white;
    border: none;
    font-size: 18px;
    border-radius: 8px;
    cursor: pointer;
    font-weight: 700;
    box-shadow: 0 5px 15px rgba(191,160,74,0.7);
    transition: background 0.3s ease, transform 0.2s ease;
}

button.submit-btn:hover {
    background: linear-gradient(135deg, #805c00, #bfa04a);
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(191,160,74,0.9);
}

#verify_icon {
    font-size: 20px;
    vertical-align: middle;
    color: #d4af37;
    text-shadow: 0 0 4px #bfa04a;
}

#chargesInfo {
    background: #333; /* dark gray box */
    border: 1px solid #bfa04a;
    padding: 14px 18px;
    margin-bottom: 24px;
    border-radius: 8px;
    font-size: 16px;
    color: #d4af37;
    box-shadow: 0 0 10px rgba(191,160,74,0.6);
    font-weight: 600;
}

</style>

</head>
<body>
<!--<header>
  <strong>Manual Payout System</strong>
</header>--->

<div class="mobile-menu" id="mobileMenu">
  <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
</div>

<header>
    <h1><i class="fas fa-money-check-alt"></i> Withdrawal Request</h1>
</header>


<!--------------start timer is today is not friday ---->
<?php
// Get today’s day of the week
$today = date("l"); // e.g. Monday, Tuesday...

if ($today !== "Friday") {
    // Find next Friday
    $nextFriday = strtotime("next Friday");
    $nextFridayDate = date("Y-m-d 00:00:00", $nextFriday);
    ?>
    
    <div class="container" style="text-align:center;">
        <h2 style="color:#d4af37;">Withdraw take place only on Friday</h2>
        <div style="color:green;font-size:24px">Time Left</div>
        
        <div id="countdown" style="font-size:34px; color:white; margin-top:0px; font-weight:bold;"></div>
    </div>

    <script>
    // Countdown Timer JS
    const nextFriday = new Date("<?= $nextFridayDate ?>").getTime();

    function updateCountdown() {
        const now = new Date().getTime();
        const distance = nextFriday - now;

        if (distance <= 0) {
            location.reload(); // Refresh page when Friday starts
        } else {
            const days = Math.floor(distance / (1000 * 60 * 60 * 24));
            const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((distance % (1000 * 60)) / 1000);

            document.getElementById("countdown").innerHTML =
                (days > 0 ? days + "d " : "") + hours + "h " + minutes + "m " + seconds + "s";
        }
    }

    setInterval(updateCountdown, 1000);
    updateCountdown();
    </script>

    <?php
    // Stop page execution so form won’t show
    exit;
}
?>
<!--------------end of timer is today is not friday ---->

<div class="container">
    <div align="center" style="font-size:20px;color:green"> <?php @$message;?></div>

    <?php if($earning_wallet>0){?>
        <p><strong>Wallet Balance:</strong> ₦<?= number_format($earning_wallet, 2) ?></p>
    <?php } else { ?>
        <p><strong>Wallet Balance:</strong> ₦<?= $earning_wallet ?></p>
    <?php } ?>

    <?php if (!$withdraw_pin): ?>
        <form method="POST">
            <label>Set 4-digit Withdrawal PIN</label>
            <input type="password" name="new_pin" required pattern="\d{4}" maxlength="4" placeholder="Enter 4-digit PIN">
            <button class="submit-btn" type="submit" name="set_pin"><i class="fas fa-lock"></i> Set PIN</button>
        </form>
    <?php else: ?>
        <form method="POST">
            <div class="amount-options">
                <?php foreach ([2000,5000,10000,20000,50000,100000,500000] as $amt): ?>
                    <button type="button" onclick="document.getElementById('amount').value = <?= $amt ?>;">₦<?= number_format($amt) ?></button>
                <?php endforeach; ?>
            </div>

            <input type="number" name="amount" id="amount" min="100" placeholder="Or enter custom amount" readonly>
            <input type="text" name="bank_name" placeholder="Bank Name" required>
            <input type="number" name="account_number" placeholder="Account Number" required>
            <input type="text" name="account_name" placeholder="Account Name" required>
            <input type="password" name="withdraw_pin" placeholder="Enter Withdrawal PIN" required maxlength="4">
            <button class="submit-btn" type="submit" name="request_withdrawal"><i class="fas fa-paper-plane"></i> Submit Request</button>
        </form>
    <?php endif; ?>
</div>



<?php if (!empty($message)): ?>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const isWithdrawRequest = <?= isset($_POST['request_withdrawal']) && $message_type === 'success' ? 'true' : 'false' ?>;
        Swal.fire({
            icon: '<?= $message_type ?>',
            title: '<?= $message_type === "success" ? "Success" : "Error" ?>',
            html: '<?= nl2br($message) ?>',
            confirmButtonText: isWithdrawRequest ? 'Go to History' : 'Close'
        }).then((result) => {
            if (isWithdrawRequest) {
                window.location.href = 'withdrawal_history.php';
            }
        });
    });
</script>
<?php endif; ?>


<script>
 function hidePreloader() {
        document.getElementById("preloader").style.display = "none";
    }
</script>

 
 <style>
 /* Global box-sizing for consistent sizing */
*, *::before, *::after {
  box-sizing: border-box;
}

body {
    margin: 0;
    font-family: 'Segoe UI', sans-serif;
    background: #1c1c1c; /* very dark gray/black background */
    color: #ddd; /* light gray text for readability */
}

header, footer {
    background: linear-gradient(135deg, black, #805c00); /* rich gold gradient */
    color: white; /* light text for contrast */
    text-align: center;
    padding: 20px 15px;
    font-weight: 700;
    letter-spacing: 1px;
    text-shadow: 0 0 5px rgba(0,0,0,0.3);
    box-shadow: 0 3px 6px rgba(0,0,0,0.5);
}

.container {
    max-width: 600px;
    margin: 40px auto;
    padding: 30px 20px; /* reduced horizontal padding */
    background: #2e2e2e; /* dark gray container */
    border-radius: 12px;
    box-shadow: 0 0 20px rgba(191,160,74,0.6); /* soft golden glow */
    color: #eee;
    overflow-x: hidden; /* prevent horizontal scroll */
}

h2 {
    text-align: center;
    color: #d4af37; /* gold color */
    
    margin-bottom: 25px;
}

/* Amount options container with responsive grid */
.amount-options {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(100px, 1fr)); /* flexible columns */
    gap: 10px;
}

/* 3 columns explicitly on small screens */
@media (max-width: 600px) {
    .amount-options {
        grid-template-columns: repeat(3, 1fr);
    }
}

.amount-options button {
    width: 100%;
    max-width: 100%;
    padding: 10px 10px;
    background: linear-gradient(145deg, black, #a67c00);
    color: white;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    font-weight: 600;
    box-shadow: 0 3px 6px rgba(166,124,0,0.6);
    transition: background 0.3s ease, transform 0.2s ease;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}
.amount-options button:hover {
    background: linear-gradient(145deg, #a67c00, #d4af37);
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(166,124,0,0.8);
}

input, select {
    width: 100%;
    padding: 14px;
    margin: 10px 0 24px;
    border-radius: 8px;
    border: 1.5px solid #bfa04a;
    background: #444; /* dark input background */
    color: #eee;
    font-weight: 600;
    box-shadow: inset 0 0 6px rgba(191,160,74,0.4);
    transition: border-color 0.3s ease;
}

input:focus, select:focus {
    border-color: #d4af37;
    outline: none;
    box-shadow: 0 0 8px #d4af37;
    background: #555;
    color: #fff;
}

button.submit-btn {
    width: 100%;
    padding: 16px;
    background: linear-gradient(135deg, black, #805c00);
    color: white;
    border: none;
    font-size: 18px;
    border-radius: 8px;
    cursor: pointer;
    font-weight: 700;
    box-shadow: 0 5px 15px rgba(191,160,74,0.7);
    transition: background 0.3s ease, transform 0.2s ease;
}

button.submit-btn:hover {
    background: linear-gradient(135deg, #805c00, #bfa04a);
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(191,160,74,0.9);
}

#verify_icon {
    font-size: 20px;
    vertical-align: middle;
    color: #d4af37;
    text-shadow: 0 0 4px #bfa04a;
}

#chargesInfo {
    background: #333; /* dark gray box */
    border: 1px solid #bfa04a;
    padding: 14px 18px;
    margin-bottom: 24px;
    border-radius: 8px;
    font-size: 16px;
    color: #d4af37;
    box-shadow: 0 0 10px rgba(191,160,74,0.6);
    font-weight: 600;
}

</style>


<footer>
    <p>&copy; <?= date('Y') ?> <?= htmlspecialchars($_SERVER['HTTP_HOST']) ?>. All rights reserved.</p>
</footer>
</body>
</html>

