<?php
session_start();
require_once "connect.php";

header('Content-Type: application/json');

// Must be logged in
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    http_response_code(403);
    echo json_encode(['status' => 'unauthorized']);
    exit;
}

// Must have question id
if (!isset($_POST['question_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'invalid']);
    exit;
}

$phone_number = $_SESSION['phone_number'];
$qid = (int)$_POST['question_id'];

$today = date("Y-m-d");
$start_of_day = "$today 00:00:00";
$end_of_day   = "$today 23:59:59";
$now = date("Y-m-d H:i:s");

// Prevent duplicate record
$check = mysqli_query($con, "
    SELECT id FROM user_tasks
    WHERE phone_number = '$phone_number'
    AND question_id = '$qid'
    AND task_date BETWEEN '$start_of_day' AND '$end_of_day'
    LIMIT 1
");

if (mysqli_num_rows($check) === 0) {
    mysqli_query($con, "
        INSERT INTO user_tasks (phone_number, question_id, is_correct, task_date)
        VALUES ('$phone_number', '$qid', 0, '$now')
    ");
}

// Clear timer session so next question starts fresh
unset($_SESSION['task_timer']);
unset($_SESSION['active_question_id']);

echo json_encode([
    'status'  => 'failed',
    'message' => 'Time expired. Question marked as failed.'
]);
exit;
