<?php
session_start();
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login.php");
    exit;
}
require_once "connect.php";
$phone_number = $_SESSION['phone_number'];

// ---- Package checks (no die; show inside template) ----
$access_block_reason = null; // when set, we will show a styled message in the page

$package_user = mysqli_fetch_assoc(mysqli_query($con, "SELECT package_end_date FROM user_packages WHERE phone_number = '$phone_number'"));

if (!$package_user) {
    // No active package found
    $access_block_reason = 'You do not have an active package. Please <a href="packages.php">purchase or renew your package</a> to access tasks.';
}

$package_end_date = $package_user['package_end_date'] ?? null;

if (!$access_block_reason) {
    if (!$package_end_date || strtotime($package_end_date) < time()) {
        // Package expired or no end date
        $access_block_reason = 'Your package has expired. Please <a href="packages.php">renew your package</a> to continue accessing tasks.';
    }
}

// ---- User and package info (kept intact) ----
$user = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM members WHERE phone_number = '$phone_number'"));
$wallet_balance = $user['earning_wallet'] ?? 0;

$package_data = mysqli_fetch_assoc(mysqli_query($con, "SELECT level FROM user_packages WHERE phone_number = '$phone_number'"));
$level = $package_data['level'] ?? null;

$package = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM packages WHERE level = '$level'"));
$task_limit = $package['task_limit'] ?? 0;
$task_rate  = $package['task_rate']  ?? 0;

$today = date("Y-m-d");
$start_of_day = "$today 00:00:00";
$end_of_day   = "$today 23:59:59";

$attempts_result = mysqli_query($con, "SELECT * FROM user_tasks WHERE phone_number = '$phone_number' AND task_date BETWEEN '$start_of_day' AND '$end_of_day'");
$task_count_today = mysqli_num_rows($attempts_result);




// ---- Handle answer submit only if access not blocked ----
if (
    !$access_block_reason &&
    $_SERVER['REQUEST_METHOD'] === 'POST' &&
    isset($_POST['question_id'], $_POST['answer'])
) {

    // 🔒 HARD CHECK: prevent submit after timeout
    if (
        isset($_SESSION['task_timer']) &&
        time() - $_SESSION['task_timer']['start_time'] > 60
    ) {
        // Force fail instead of accepting answer
        header("Location: task_timeout.php");
        exit;
    }

    $qid = intval($_POST['question_id']);
    $user_answer = trim($_POST['answer']);
    $q = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM task_questions WHERE id = '$qid'"));

    if ($q) {
        $correct = strtolower($user_answer) === strtolower($q['correct_option']) ? 1 : 0;
        $now = date("Y-m-d H:i:s");

        mysqli_query($con, "INSERT INTO user_tasks (phone_number, question_id, is_correct, task_date) VALUES ('$phone_number', '$qid', '$correct', '$now')");
        unset($_SESSION['task_timer']);
        unset($_SESSION['active_question_id']);



        if ($correct) {
            mysqli_query($con, "UPDATE members SET earning_wallet = earning_wallet + $task_rate WHERE phone_number = '$phone_number'");
            $feedback = "Correct! ₦$task_rate has been added to your wallet.";
            $feedback_icon = "success";
        } else {
            $feedback = "Wrong answer. Try again tomorrow!";
            $feedback_icon = "error";
        }

        echo "<script>
            localStorage.setItem('feedback', JSON.stringify({message: '$feedback', icon: '$feedback_icon'}));
            location.href = 'task.php';
        </script>";
        exit;
    }
}

// ---- Fetch a question only if access not blocked and within limits ----
/*
$question = null;
if (!$access_block_reason && $task_count_today < $task_limit && $task_limit > 0) {
    $answered_ids = [];
    $answered_result = mysqli_query($con, "SELECT question_id FROM user_tasks WHERE phone_number = '$phone_number' AND task_date BETWEEN '$start_of_day' AND '$end_of_day'");
    while ($ans = mysqli_fetch_assoc($answered_result)) {
        $answered_ids[] = $ans['question_id'];
    }
    $exclude_ids = implode(",", $answered_ids) ?: "0";
    $question_query = mysqli_query($con, "SELECT * FROM task_questions WHERE id NOT IN ($exclude_ids) ORDER BY RAND() LIMIT 1");
    $question = mysqli_fetch_assoc($question_query);
}
*/


$question = null;

if (
    !$access_block_reason &&
    $task_count_today < $task_limit &&
    $task_limit > 0
) {

    // If a question is already locked in session, reuse it
    if (isset($_SESSION['active_question_id'])) {
        $qid = (int)$_SESSION['active_question_id'];
        $question = mysqli_fetch_assoc(
            mysqli_query($con, "SELECT * FROM task_questions WHERE id = '$qid' LIMIT 1")
        );
    }

    // Otherwise, fetch a new one and lock it
    if (!$question) {
        $answered_ids = [];
        $answered_result = mysqli_query($con, "
            SELECT question_id 
            FROM user_tasks 
            WHERE phone_number = '$phone_number' 
            AND task_date BETWEEN '$start_of_day' AND '$end_of_day'
        ");
        while ($ans = mysqli_fetch_assoc($answered_result)) {
            $answered_ids[] = $ans['question_id'];
        }

        $exclude_ids = implode(",", $answered_ids) ?: "0";

        $question_query = mysqli_query($con, "
            SELECT * 
            FROM task_questions 
            WHERE id NOT IN ($exclude_ids)
            ORDER BY RAND()
            LIMIT 1
        ");

        $question = mysqli_fetch_assoc($question_query);

        if ($question) {
            $_SESSION['active_question_id'] = $question['id'];
        }
    }
}




// ---- Start anti-refresh timer (server-side) ----
$question = null;

if (
    !$access_block_reason &&
    $task_count_today < $task_limit &&
    $task_limit > 0
) {

    // If a question is already locked in session, reuse it
    if (isset($_SESSION['active_question_id'])) {
        $qid = (int)$_SESSION['active_question_id'];
        $question = mysqli_fetch_assoc(
            mysqli_query($con, "SELECT * FROM task_questions WHERE id = '$qid' LIMIT 1")
        );
    }

    // Otherwise, fetch a new one and lock it
    if (!$question) {
        $answered_ids = [];
        $answered_result = mysqli_query($con, "
            SELECT question_id 
            FROM user_tasks 
            WHERE phone_number = '$phone_number' 
            AND task_date BETWEEN '$start_of_day' AND '$end_of_day'
        ");
        while ($ans = mysqli_fetch_assoc($answered_result)) {
            $answered_ids[] = $ans['question_id'];
        }

        $exclude_ids = implode(",", $answered_ids) ?: "0";

        $question_query = mysqli_query($con, "
            SELECT * 
            FROM task_questions 
            WHERE id NOT IN ($exclude_ids)
            ORDER BY RAND()
            LIMIT 1
        ");

        $question = mysqli_fetch_assoc($question_query);

        if ($question) {
            $_SESSION['active_question_id'] = $question['id'];
            // 💡 Only set timer now
            $_SESSION['task_timer'] = [
                'question_id' => $question['id'],
                'start_time'  => time()
            ];
        }
    }
}

// ---- Calculate remaining seconds (anti-refresh) ----
$remaining_seconds = 60;

if (isset($_SESSION['task_timer']) && $question) {
    $elapsed = time() - $_SESSION['task_timer']['start_time'];
    $remaining_seconds = max(0, 60 - $elapsed);
}




// ---- Calculate remaining seconds (anti-refresh) ----
$remaining_seconds = 60;

if (isset($_SESSION['task_timer']) && $question) {
    $elapsed = time() - $_SESSION['task_timer']['start_time'];
    $remaining_seconds = max(0, 60 - $elapsed);
}



// ---- FORCE TIMEOUT ON PAGE LOAD (ANTI-REFRESH ENFORCEMENT) ----
if (
    $question &&
    isset($_SESSION['task_timer']) &&
    $_SESSION['task_timer']['question_id'] == $question['id'] &&
    $remaining_seconds <= 0
) {
    // Mark failed immediately
    $now = date("Y-m-d H:i:s");

    $check = mysqli_query($con, "
        SELECT id FROM user_tasks
        WHERE phone_number = '$phone_number'
        AND question_id = '{$question['id']}'
        AND task_date BETWEEN '$start_of_day' AND '$end_of_day'
        LIMIT 1
    ");

    if (mysqli_num_rows($check) === 0) {
        mysqli_query($con, "
            INSERT INTO user_tasks (phone_number, question_id, is_correct, task_date)
            VALUES ('$phone_number', '{$question['id']}', 0, '$now')
        ");
    }

    unset($_SESSION['task_timer']);
    unset($_SESSION['active_question_id']);

    echo "<script>
        Swal.fire({
            icon: 'error',
            title: '⏰ Time Up!',
            text: 'You failed this question. Daily task count reduced.',
            allowOutsideClick: false
        }).then(() => {
            location.href = 'task.php';
        });
    </script>";
    exit;
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Daily Task - CashFunz</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
  body {
    margin: 0;
    font-family: 'Segoe UI', sans-serif;
    background: linear-gradient(135deg, #1c1c1c, #2e2e2e);
    color: #fff;
  }

  header {
    background: linear-gradient(to right, #d4af37, #000000);
    color: #fff;
    padding: 1em;
    text-align: center;
    position: relative;
    box-shadow: 0 3px 8px rgba(0, 0, 0, 0.4);
  }

  .hamburger {
    position: absolute;
    left: 15px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 20px;
    cursor: pointer;
    color: #d4af37;
  }

  #mobileMenu {
    display: none;
    background: #2c2c2c;
    padding: 10px;
    border-top: 1px solid #555;
  }

  #mobileMenu a {
    display: block;
    padding: 10px;
    color: #d4af37;
    text-decoration: none;
    border-bottom: 1px solid #444;
    transition: background 0.3s ease, color 0.3s ease;
  }

  #mobileMenu a:hover {
    background: #444;
    color: #fff;
  }

  .container {
    max-width: 600px;
    margin: 20px auto;
    background: linear-gradient(145deg, #3a3a3a, #2b2b2b);
    padding: 20px;
    border-radius: 12px;
    box-shadow: 0 3px 12px rgba(0, 0, 0, 0.5);
    color: #ddd;
  }

  h2 {
    color: #d4af37;
    margin-bottom: 10px;
    text-align: center;
  }

  .stats,
  .progress {
    display: flex;
    justify-content: space-between;
    margin: 10px 0;
    font-size: 15px;
    color: #ccc;
  }

  form button {
    background: linear-gradient(to right, #d4af37, #b8860b);
    color: black;
    border: none;
    padding: 10px 20px;
    border-radius: 6px;
    cursor: pointer;
    font-weight: bold;
    transition: background 0.3s ease;
  }

  form button:hover {
    background: linear-gradient(to right, #ffd700, #d4af37);
  }

  .question-block {
    margin-top: 20px;
  }

  .footer {
    background: linear-gradient(to right, #000000, #d4af37);
    color: white;
    text-align: center;
    padding: 1em;
    margin-top: 40px;
    border-top-left-radius: 12px;
    border-top-right-radius: 12px;
    box-shadow: 0 -3px 8px rgba(212, 175, 55, 0.6);
  }

  #preloader {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: #1c1c1c;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 999;
  }

  .circle-animation {
    width: 220px;
    height: 220px;
    margin: 0 auto 20px;
    border: 10px solid #d4af37;
    border-top: 10px solid #000000;
    border-radius: 50%;
    animation: spin 4s linear infinite;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .circle-animation img {
    width: 100px;
    height: 100px;
  }

  @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
  }

  input[type="radio"] {
    margin-right: 5px;
  }

  /* --- Styled alert box for blocked access --- */
  .alert-box {
    margin: 18px 0 0 0;
    background: #2b2b2b;
    border: 2px solid #d4af37;
    color: #ffd;
    padding: 16px;
    border-radius: 10px;
    text-align: center;
    box-shadow: 0 0 10px rgba(212, 175, 55, 0.25);
  }
  .alert-box .title {
    color: #d4af37;
    font-weight: 700;
    margin-bottom: 6px;
  }
  .alert-box a {
    color: #d4af37;
    font-weight: 600;
    text-decoration: underline;
  }

  @media (max-width: 600px) {
    .container {
      margin: 10px;
      padding: 15px;
    }
  }
</style>
</head>
<body>
<div id="preloader"><i class="fas fa-spinner fa-spin fa-3x"></i></div>

<audio id="bgAudio" src="track.mp3" autoplay loop></audio>

<header>
    <div class="hamburger"><i class="fas fa-bars"></i></div>
    Daily Task
</header>

<nav id="mobileMenu">
    <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
   <!-- <a href="task.php"><i class="fas fa-clipboard-list"></i> Daily Task</a>
    <a href="activate_package.php"><i class="fas fa-bolt"></i> Activate Package</a>--->
    <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
</nav>

<div class="container">
    <div class="stats">
        <div><i class="fas fa-wallet"></i> Balance: <strong style="color:green;">₦<?= number_format((float)$wallet_balance, 2) ?></strong></div>
        <div><i class="fas fa-coins"></i> Earn/Task: ₦<?= (float)$task_rate ?></div>
    </div>
    <div class="progress">
        <div><i class="fas fa-tasks"></i> Progress: <?= (int)$task_count_today ?> of <?= (int)$task_limit ?></div>
    </div>

    <?php if ($access_block_reason): ?>
        <!-- Show styled alert instead of die(); -->
        <div class="alert-box">
            <div class="title"><i class="fas fa-exclamation-triangle"></i> Action Required</div>
            <div><?= $access_block_reason ?></div>
        </div>

    <?php elseif ($task_limit > 0): ?>
        <?php if ($task_count_today >= $task_limit): ?>
            <p style="color:red; font-weight: bold;">You have reached your daily task limit. Upgrade to a higher package to earn more daily!</p>
        <?php elseif ($question): ?>
            <h2>Today's Question</h2>
            <div class="circle-animation">
                <img src="images/logoc.png" alt="Logo">
            </div>
            
            
            
            
            <div id="timerBox" style="
    text-align:center;
    margin:15px 0;
    padding:12px;
    border-radius:10px;
    background:linear-gradient(135deg,#000,#d4af37);
    font-weight:bold;
    box-shadow:0 0 12px rgba(212,175,55,.6);
">
    ⏳ Time Left: <span id="timeLeft">01:00</span>
</div>

            
            
            <div class="question-block">
                <p><strong><?= htmlspecialchars($question['question']) ?></strong></p>
                <form method="post">
                    <input type="hidden" name="question_id" value="<?= $question['id'] ?>">
                    <?php foreach (['option_a','option_b','option_c','option_d'] as $opt): ?>
                        <div><input type="radio" name="answer" value="<?= htmlspecialchars($question[$opt]) ?>" required> <?= htmlspecialchars($question[$opt]) ?></div>
                    <?php endforeach; ?>
                    <br>
                    <button type="submit"><i class="fas fa-check"></i> Submit Answer</button>
                </form>
            </div>
        <?php else: ?>
            <p>No more questions available. Please check back later.</p>
        <?php endif; ?>
    <?php else: ?>
        <p style="color:red; font-weight: bold;">Your current package does not allow daily tasks. <a href="packages.php"><i class="fas fa-bolt"></i> Upgrade now</a></p>
    <?php endif; ?>
</div>

<div class="footer">&copy; <?= date('Y') ?> CashFunz</div>

<script>
window.addEventListener('load', () => {
    document.getElementById('preloader').style.display = 'none';

    const fb = localStorage.getItem('feedback');
    if (fb) {
        const { message, icon } = JSON.parse(fb);
        Swal.fire({ icon: icon, text: message });
        localStorage.removeItem('feedback');
    }

    const audio = document.getElementById('bgAudio');
    audio.play().catch(e => {
        console.log("Audio autoplay blocked:", e);
    });
});

document.querySelector('.hamburger').addEventListener('click', () => {
    const menu = document.getElementById('mobileMenu');
    menu.style.display = (menu.style.display === 'none' || menu.style.display === '') ? 'block' : 'none';
});
</script>






<script>
<?php if ($question && !$access_block_reason): ?>

let totalTime = <?= (int)$remaining_seconds ?>;
let timerInterval;
let submitted = false;

function startTimer() {
    const display = document.getElementById('timeLeft');

    timerInterval = setInterval(() => {
        totalTime--;

        display.textContent =
            `00:${String(totalTime).padStart(2, '0')}`;

        if (totalTime <= 0 && !submitted) {
            clearInterval(timerInterval);
            submitted = true;
            submitTimeout();
        }
    }, 1000);
}

function submitTimeout() {
    fetch('task_timeout.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: 'question_id=<?= $question['id'] ?>'
    })
    .then(res => res.json())
    .then(() => showTimeoutAlert())
    .catch(() => location.reload());
}

function showTimeoutAlert() {
    let sec = 6;

    Swal.fire({
        icon: 'error',
        title: '⏰ Time Up!',
        html: `
            <p><b>You failed this question.</b></p>
            <p>Daily task count has been reduced.</p>
            <p>Next question in <b><span id="sec">6</span></b> seconds</p>
        `,
        allowOutsideClick: false,
        allowEscapeKey: false,
        didOpen: () => {
            const el = document.getElementById('sec');
            const i = setInterval(() => {
                sec--;
                el.textContent = sec;
                if (sec <= 0) {
                    clearInterval(i);
                    location.reload();
                }
            }, 1000);
        }
    });
}

// Stop timer if user submits manually
document.querySelector('form')?.addEventListener('submit', () => {
    submitted = true;
    clearInterval(timerInterval);
});

// Auto-fail immediately if already expired
if (totalTime <= 0) {
    submitTimeout();
} else {
    startTimer();
}

<?php endif; ?>
</script>



</body>
</html>
