<?php
session_start();
include('connect.php');

// Redirect if not logged in
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: login.php");
    exit;
}

$error_message = "";

// Ensure phone_number is set in session
$phone_number = $_SESSION['phone_number'] ?? null;
if (!$phone_number) {
    die("Error: Session phone number not set.");
}

// Fetch user details safely
$sql2 = "SELECT * FROM members WHERE phone_number='" . mysqli_real_escape_string($con, $phone_number) . "'";
$result2 = mysqli_query($con, $sql2);

if (!$result2 || mysqli_num_rows($result2) === 0) {
    die("Error: User details not found.");
}

$data2 = mysqli_fetch_assoc($result2);
$first_name = $data2['first_name'] ?? 'N/A';
$last_name = $data2['last_name'] ?? 'N/A';
$email_address = $data2['email_address'] ?? 'N/A';
$sponsor_id = $data2['sponsor_id'] ?? 'N/A';
$member_id = $data2['member_id'] ?? 'N/A';
$main_wallet = $data2['main_wallet'] ?? 0;
$earning_wallet = $data2['earning_wallet'] ?? 0;
$email_verification_status = $data2['email_verification_status'] ?? 'Pending';
$payment_status = $data2['payment_status'] ?? 'Unpaid';
// keep if it exists in your schema; harmless if not
$package_level = $data2['package_level'] ?? 'N/A';

// Pagination setup
$limit = 10;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;

$mid_esc = mysqli_real_escape_string($con, $member_id);

// Get total referrals (ALL downlines under this sponsor)
$total_records = 0;
$total_result_sql = "SELECT COUNT(*) as total FROM members WHERE sponsor_id = '$mid_esc'";
$total_result = mysqli_query($con, $total_result_sql);
if ($total_result) {
    $total_row = mysqli_fetch_assoc($total_result);
    $total_records = $total_row['total'] ?? 0;
} else {
    $error_message = "Could not count referrals.";
}
$total_pages = $total_records > 0 ? ceil($total_records / $limit) : 1;

// Fetch referrals with activation status + per-downline earned amount
// activated = 1 if any referral_bonus exists for this sponsor+member_phone
// earned_amount = SUM(bonus_amount) for that downline under this sponsor
$query = "
    SELECT 
        m.*,
        IFNULL(rb.total_earned, 0) AS earned_amount,
        CASE 
            WHEN rb.total_earned IS NULL OR rb.total_earned = 0 THEN 0 
            ELSE 1 
        END AS activated
    FROM members m
    LEFT JOIN (
        SELECT member_phone, sponsor_id, SUM(bonus_amount) AS total_earned
        FROM referral_bonus
        WHERE sponsor_id = '$mid_esc'
        GROUP BY sponsor_id, member_phone
    ) rb ON rb.member_phone = m.phone_number
    WHERE m.sponsor_id = '$mid_esc'
    ORDER BY m.created_at DESC
    LIMIT $limit OFFSET $offset
";
$result = mysqli_query($con, $query);
if (!$result) {
    $error_message = "Could not load referrals.";
}

// Calculate total earned bonus safely
$total_bonus = 0;
$sum_sql = "SELECT SUM(bonus_amount) as total_bonus FROM referral_bonus WHERE sponsor_id = '$mid_esc'";
$sum_result = mysqli_query($con, $sum_sql);
if ($sum_result) {
    $sum_row = mysqli_fetch_assoc($sum_result);
    $total_bonus = $sum_row['total_bonus'] ?? 0;
} else {
    $error_message = $error_message ?: "Could not load total bonus.";
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Referral History</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #1a1a1a;
            margin: 0;
            color: #d4af37;
        }
        header {
            background: linear-gradient(135deg, black, #333333);
            color: #d4af37;
            padding: 15px 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            box-shadow: 0 2px 8px rgba(212, 175, 55, 0.6);
        }
        header h1 {
            margin: 0;
            font-size: 22px;
            color: #d4af37;
            text-shadow: 0 0 5px #d4af37;
        }
        .hamburger {
            font-size: 24px;
            cursor: pointer;
            display: none;
            color: #d4af37;
        }
        nav {
            background: linear-gradient(135deg, #000000, #222222);
            color: #d4af37;
            padding: 10px 20px;
            box-shadow: inset 0 -2px 5px rgba(212, 175, 55, 0.3);
        }
        .nav-links {
            display: flex;
            gap: 15px;
        }
        .nav-links a {
            color: #d4af37;
            text-decoration: none;
            font-weight: bold;
            transition: color 0.3s ease;
        }
        .nav-links a:hover {
            color: #ffd700;
        }
        .container {
            max-width: 900px;
            margin: 30px auto;
            background: #222222;
            padding: 25px;
            border-radius: 8px;
            box-shadow: 0 0 12px rgba(212, 175, 55, 0.6);
            color: #d4af37;
        }
        h2 {
            text-align: center;
            color: white;
            text-shadow: 0 0 5px #d4af37;
        }
        .total-box {
            background: #333333;
            border: 2px solid #d4af37;
            color: #d4af37;
            font-size: 20px;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 0 10px rgba(212, 175, 55, 0.4);
        }
        .referral-section {
            text-align: center;
            margin: 20px auto;
        }
        .referral-section input {
            width: 70%;
            padding: 10px;
            font-size: 16px;
            color: #222;
            border: 2px solid #d4af37;
            border-radius: 5px;
            margin-right: 10px;
        }
        .referral-section button {
            background: #d4af37;
            color: #000;
            border: none;
            padding: 10px 15px;
            font-size: 16px;
            border-radius: 5px;
            cursor: pointer;
            transition: background 0.3s ease;
        }
        .referral-section button:hover {
            background: #ffd700;
            color: #222;
        }

        /* Responsive table wrapper to prevent overflow on mobile */
        .table-wrap {
            width: 100%;
            overflow-x: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
            /* keeps layout stable when scrolled on mobile */
            min-width: 620px;
        }
        th, td {
            padding: 12px;
            text-align: center;
            border-bottom: 1px solid #555555;
            white-space: nowrap;
        }
        th {
            background: linear-gradient(135deg, #000000, #333333);
            color: #d4af37;
            text-shadow: 0 0 5px #d4af37;
        }
        .activated { color: #00ff00; font-weight: bold; }
        .pending { color: #ff4d4d; font-weight: bold; }
        .pagination {
            margin-top: 25px;
            text-align: center;
        }
        .pagination a {
            margin: 0 5px;
            color: #d4af37;
            padding: 8px 12px;
            text-decoration: none;
            border: 1px solid #d4af37;
            border-radius: 4px;
            transition: background 0.3s ease, color 0.3s ease;
        }
        .pagination a.active {
            background-color: #d4af37;
            color: #222222;
            box-shadow: 0 0 8px #ffd700;
        }
        .pagination a:hover {
            background: #ffd700;
            color: #222222;
            box-shadow: 0 0 12px #ffd700;
        }
        @media (max-width: 768px) {
            .nav-links { display: none; flex-direction: column; background: linear-gradient(135deg, #000000, #222222); width: 100%; box-shadow: 0 4px 10px rgba(212, 175, 55, 0.3); }
            .nav-links.active { display: flex; }
            .hamburger { display: block; }
            /* make inputs full width on small screens */
            .referral-section input { width: 100%; margin: 0 0 10px 0; }
            .referral-section button { width: 100%; }
        }
    </style>
</head>
<body>
<header>
    <h1><i class="fas fa-hand-holding-usd"></i> Referral History</h1>
    <div class="hamburger" onclick="toggleMenu()"><i class="fas fa-bars"></i></div>
</header>
<nav>
    <div class="nav-links" id="navLinks">
        <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
        <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>
</nav>

<!-- REFERRAL SECTION -->
<div class="referral-section">
    <input type="hidden" id="referralLink" value="https://cashfunz.com/register.php?sponsor=<?php echo htmlspecialchars($member_id); ?>" readonly>
    <button onclick="copyReferralLink()"><i class="fas fa-copy"></i> Copy Referral Link</button>
</div>

<div class="container">
    <h2>Your Referred Members</h2>
    <div class="total-box">
        <strong>Total Referral Bonus Earned:</strong> ₦<?= number_format($total_bonus, 2) ?>
    </div>

    <?php if ($error_message): ?>
        <p style="text-align:center;color:#ff4d4d;font-weight:bold;"><?= htmlspecialchars($error_message) ?></p>
    <?php endif; ?>

    <?php if ($result && mysqli_num_rows($result) > 0): ?>
        <div class="table-wrap">
            <table>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Status</th>
                        <th>Amount Earned</th>
                        <th>Date Joined</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $sn = $offset + 1; ?>
                    <?php while ($row = mysqli_fetch_assoc($result)): ?>
                        <tr>
                            <td><?= $sn++ ?></td>
                            <td><?= htmlspecialchars(($row['first_name'] ?? '') . ' ' . ($row['last_name'] ?? '')) ?></td>
                            <td><?= htmlspecialchars($row['phone_number'] ?? 'N/A') ?></td>
                            <td>
                                <?php if (!empty($row['activated'])): ?>
                                    <span class="activated">Activated</span>
                                <?php else: ?>
                                    <span class="pending">Pending</span>
                                <?php endif; ?>
                            </td>
                            <td>₦<?= number_format((float)($row['earned_amount'] ?? 0), 2) ?></td>
                            <td><?= isset($row['created_at']) ? date('d M Y', strtotime($row['created_at'])) : 'N/A' ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <div class="pagination">
            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <a class="<?= $i === $page ? 'active' : '' ?>" href="?page=<?= $i ?>"><?= $i ?></a>
            <?php endfor; ?>
        </div>
    <?php else: ?>
        <p style="text-align: center; font-size: 18px; color: #888;">No referrals yet.</p>
    <?php endif; ?>
</div>

<script>
function toggleMenu() {
    document.getElementById("navLinks").classList.toggle("active");
}

function copyReferralLink() {
    const input = document.getElementById("referralLink");
    const text = input.value;

    if (navigator.clipboard && window.isSecureContext) {
        navigator.clipboard.writeText(text).then(showCopied, fallbackCopy);
    } else {
        fallbackCopy();
    }

    function fallbackCopy() {
        input.select();
        input.setSelectionRange(0, 99999);
        document.execCommand("copy");
        showCopied();
    }

    function showCopied() {
        Swal.fire({
            icon: 'success',
            title: 'Copied!',
            text: 'Referral link copied to clipboard!',
            background: '#222',
            color: '#d4af37',
            confirmButtonColor: '#d4af37'
        });
    }
}
</script>
</body>
</html>
