<?php
if (!function_exists('getEnvValue')) {
    function getEnvValue($key) {
        $file = __DIR__ . '/.env';
        if (!file_exists($file)) {
            return null;
        }
        $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            if (strpos(trim($line), '#') === 0) continue;
            [$envKey, $envValue] = explode('=', $line, 2);
            if (trim($envKey) === $key) {
                return trim($envValue);
            }
        }
        return null;
    }
}
