<?php
// Initialize the session
session_start();
 
// Check if the user is logged in, if not then redirect him/her to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}


// Include config file
require_once "config.php";
 include('connect.php');
 
 
///////////select user details
$sql2 ="SELECT * FROM members WHERE phone_number={$_SESSION['phone_number']}";   
$result2 = mysqli_query($con, $sql2);
$data2 = mysqli_fetch_array($result2);
$first_name = $data2['first_name'];
$last_name = $data2['last_name'];
$phone_number = $data2['phone_number'];
$email_address= $data2['email_address'];
$sponsor_id= $data2['sponsor_id'];
$member_id= $data2['member_id'];
$main_wallet= $data2['main_wallet'];
$earning_wallet= $data2['earning_wallet'];
$email_verification_status= $data2['email_verification_status'];
$payment_status= $data2['payment_status'];
$package_level= $data2['package_level'];


$phone = $_SESSION['phone_number'] ?? '';
$history = [];

if ($phone) {
    $result = mysqli_query($con, "SELECT * FROM deposits WHERE phone_number='$phone' ORDER BY date_submitted DESC");
    while ($row = mysqli_fetch_assoc($result)) {
        $history[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>Deposit History</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
 <style>
  body {
    font-family: Arial, sans-serif;
    background: #1a1a1a; /* very dark gray/black */
    margin: 0;
    padding: 0;
    color: #ddd;
  }

  header {
    background: linear-gradient(90deg, #805c00, #bfa04a); /* rich gold gradient */
    color: #1a1a1a;
    padding: 15px;
    text-align: center;
    position: relative;
    box-shadow: 0 3px 6px rgba(191,160,74,0.6);
  }

  .hamburger {
    position: absolute;
    left: 20px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 22px;
    cursor: pointer;
    color: #d4af37;
    text-shadow: 0 0 4px rgba(191,160,74,0.7);
  }

  .mobile-menu {
    display: none;
    background: linear-gradient(90deg, #805c00, #bfa04a);
    padding: 10px;
    text-align: center;
    box-shadow: 0 4px 10px rgba(191,160,74,0.4);
    border-radius: 0 0 10px 10px;
  }

  .mobile-menu a {
    color: #1a1a1a;
    display: block;
    padding: 10px 0;
    text-decoration: none;
    font-weight: 600;
    text-shadow: 0 0 4px rgba(191,160,74,0.7);
  }

  .mobile-menu a:hover {
    color: #f0d86b;
  }

  .container {
    max-width: 900px;
    margin: 30px auto;
    background: #2e2e2e;
    padding: 20px 30px;
    border-radius: 12px;
    box-shadow: 0 0 20px rgba(191,160,74,0.6);
    color: #eee;
  }

  .title {
    font-size: 22px;
    color: #d4af37;
    margin-bottom: 20px;
    text-align: center;
    text-shadow: 0 0 8px #bfa04a;
  }

  table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    background: #1e1e1e;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 0 10px rgba(191,160,74,0.4);
  }

  th, td {
    text-align: left;
    padding: 12px 10px;
    border-bottom: 1px solid #444;
    font-weight: 600;
  }

  th {
    background: linear-gradient(90deg, #805c00, #bfa04a);
    color: #1a1a1a;
    text-shadow: 0 0 4px rgba(191,160,74,0.7);
  }

  td i {
    color: #d4af37;
    margin-right: 5px;
  }

  .status-pending {
    color: #f0a500; /* golden orange */
    font-weight: 700;
  }

  .status-approved {
    color: #28a745; /* green */
    font-weight: 700;
  }

  .status-declined {
    color: #dc3545; /* red */
    font-weight: 700;
  }

  footer {
    background: #1a1a1a;
    color: #bfa04a;
    text-align: center;
    padding: 15px;
    margin-top: 40px;
    box-shadow: inset 0 1px 5px rgba(191,160,74,0.4);
  }

  #preloader {
    position: fixed;
    top: 0; left: 0; right: 0; bottom: 0;
    background: #1a1a1a;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
  }

  @media screen and (max-width: 600px) {
    table, thead, tbody, th, td, tr {
      display: block;
    }

    th {
      display: none;
    }

    td {
      border: none;
      padding: 10px 10px 10px 50%;
      position: relative;
      border-bottom: 1px solid #444;
    }

    td::before {
      content: attr(data-label);
      position: absolute;
      left: 10px;
      top: 10px;
      font-weight: 700;
      color: #d4af37;
      text-shadow: 0 0 4px rgba(191,160,74,0.7);
    }
  }
</style>

</head>
<body>
<div id="preloader"><i class="fas fa-spinner fa-spin fa-3x"></i></div>

<header>
  <div class="hamburger"><i class="fas fa-bars"></i></div>
  <strong>Deposit History</strong>
</header>

<div class="mobile-menu" id="mobileMenu">
  <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
  <!--<a href="#"><i class="fas fa-wallet"></i> Wallet</a>
  <a href="#"><i class="fas fa-sign-out-alt"></i> Logout</a>--->
</div>


<div class="container">
  <div class="title"><i class="fas fa-history"></i> Your Deposit Records</div>

  <?php if (empty($history)): ?>
    <p style="text-align: center; color: #666;">No deposit history found.</p>
  <?php else: ?>
    <table>
      <thead>
        <tr>
          <th><i class="fas fa-calendar"></i> Date</th>
          <th><i class="fas fa-user"></i> Depositor</th>
          <th><i class="fas fa-coins"></i> Amount</th>
          <th><i class="fas fa-image"></i> Proof</th>
          <th><i class="fas fa-check-circle"></i> Status</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($history as $row): ?>
        <tr>
          <td data-label="Date"><?= date("d M, Y h:i A", strtotime($row['date_submitted'])) ?></td>
          <td data-label="Depositor"><?= htmlspecialchars($row['depositor']) ?></td>
          <td data-label="Amount">₦<?= number_format($row['amount'], 2) ?></td>
          <td data-label="Proof">
            <a href="uploads/<?= $row['proof'] ?>" target="_blank"><i class="fas fa-file-image"></i> View</a>
          </td>
          <td data-label="Status">
            <span class="status-<?= strtolower($row['status']) ?>">
              <?= ucfirst($row['status']) ?>
            </span>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  <?php endif; ?>
</div>

<footer>
  &copy; <?= date("Y") ?> CashFunz.com All rights reserved.
</footer>

<script>
  // Preloader
  window.addEventListener('load', () => {
    document.getElementById('preloader').style.display = 'none';
  });

  // Hamburger toggle
  document.querySelector('.hamburger').addEventListener('click', () => {
    const menu = document.getElementById('mobileMenu');
    menu.style.display = menu.style.display === 'block' ? 'none' : 'block';
  });
</script>
</body>
</html>
