<?php
// Initialize the session
session_start();
 
// Check if the user is logged in, if not then redirect him/her to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}


// Include config file
require_once "config.php";
 include('connect.php');
 
 
///////////select user details
$sql2 ="SELECT * FROM members WHERE phone_number={$_SESSION['phone_number']}";   
$result2 = mysqli_query($con, $sql2);
$data2 = mysqli_fetch_array($result2);
$first_name = $data2['first_name'];
$last_name = $data2['last_name'];
$phone_number = $data2['phone_number'];
$email_address= $data2['email_address'];
$sponsor_id= $data2['sponsor_id'];
$member_id= $data2['member_id'];
$main_wallet= $data2['main_wallet'];
$earning_wallet= $data2['earning_wallet'];
$email_verification_status= $data2['email_verification_status'];
$payment_status= $data2['payment_status'];
$package_level= $data2['package_level'];


$phone_number = $_SESSION['phone_number'];
$result = mysqli_query($con, "SELECT * FROM members WHERE phone_number = '$phone_number'");
$user = mysqli_fetch_assoc($result);

// Fetch withdrawal history
$history = mysqli_query($con, "SELECT * FROM withdrawal_requests WHERE phone_number = '$phone_number' ORDER BY request_date DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Withdrawal History</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- Styles -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

 <style>
    body {
        margin: 0;
        font-family: 'Segoe UI', sans-serif;
        background-color: #f2f2f2; /* light gray */
        color: #222; /* dark gray/black text */
    }

    .preloader {
        position: fixed;
        background: #fff8e1; /* very light gold */
        width: 100%;
        height: 100%;
        z-index: 9999;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .header {
        background-color: black; /* goldenrod */
        color: white; /* almost black */
        padding: 15px 20px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        box-shadow: 0 3px 6px rgba(0,0,0,0.3);
    }

    .header h2 {
        margin: 0;
        font-size: 20px;
        font-weight: 700;
    }

    .menu-toggle {
        font-size: 22px;
        cursor: pointer;
        color: #1a1a1a;
    }

    .container {
        padding: 20px;
    }

    .table-container {
        overflow-x: auto;
        background: #fffbea; /* pale gold */
        border-radius: 10px;
        padding: 10px;
        box-shadow: 0 0 15px rgba(184,134,11,0.3); /* soft gold shadow */
    }

    table {
        width: 100%;
        border-collapse: collapse;
        min-width: 600px;
    }

    th, td {
        padding: 10px;
        text-align: left;
        font-size: 14px;
        border-bottom: 1px solid #ccc; /* soft gray */
        color: #222;
    }

    th {
        background-color: #b8860b; /* goldenrod */
        color: #1a1a1a; /* near black */
        font-weight: 600;
        text-transform: uppercase;
    }

    .status {
        padding: 5px 10px;
        border-radius: 5px;
        color: #fff;
        font-size: 13px;
        font-weight: 600;
        text-align: center;
        min-width: 80px;
    }

    .pending { background: #daa520; }  /* goldenrod */
    .approved { background: #222; }    /* black */
    .declined { background: #555; }    /* dark gray */

    footer {
        background: #1a1a1a; /* black */
        color: #b8860b;      /* goldenrod */
        text-align: center;
        padding: 12px;
        position: fixed;
        bottom: 0;
        width: 100%;
        font-weight: 600;
        box-shadow: 0 -2px 6px rgba(184,134,11,0.5);
    }

    @media (max-width: 600px) {
        .header h2 {
            font-size: 16px;
        }
        th, td {
            font-size: 12px;
        }
    }
</style>

</head>
<body onload="hidePreloader()">
    <!-- Preloader -->
    <div class="preloader" id="preloader">
        <i class="fas fa-spinner fa-spin fa-3x text-primary"></i>
    </div>

    <!-- Header -->
    <div class="header">
        <h2><i class="fas fa-money-check-alt"></i> Withdrawal History</h2>
        <i class="fas fa-bars menu-toggle" onclick="toggleMenu()"></i>
    </div>

    <!-- Main Content -->
    <div class="container">
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Bank Name</th>
                        <th>Acct Name</th>
                        <th>Acct Number</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>Requested At</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (mysqli_num_rows($history) > 0): ?>
                        <?php while($row = mysqli_fetch_assoc($history)): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['bank_name']) ?></td>
                                <td><?= htmlspecialchars($row['account_name']) ?></td>
                                <td><?= htmlspecialchars($row['account_number']) ?></td>
                                <td>₦<?= number_format($row['amount'], 2) ?></td>
                                <td>
                                    <span class="status <?= strtolower($row['status']) ?>">
                                        <?= ucfirst($row['status']) ?>
                                    </span>
                                </td>
                                <td><?= date("M d, Y H:i", strtotime($row['request_date'])) ?></td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="6">No withdrawal history yet.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Footer -->
    <footer>
        &copy; <?= date("Y") ?> CashFunz | All rights reserved
    </footer>

    <!-- Scripts -->
    <script>
        function hidePreloader() {
            document.getElementById('preloader').style.display = 'none';
        }

        function toggleMenu() {
            Swal.fire({
                title: 'Menu',
                html: `
                    <div style="text-align:left">
                        <a href="dashboard.php" style="display:block;margin:10px 0;"><i class="fas fa-home"></i> Dashboard</a>
                        <a href="withdrawal_request.php" style="display:block;margin:10px 0;"><i class="fas fa-hand-holding-usd"></i> Request Withdrawal</a>
                        <a href="logout.php" style="display:block;margin:10px 0;"><i class="fas fa-sign-out-alt"></i> Logout</a>
                    </div>`,
                showCloseButton: true,
                showConfirmButton: false
            });
        }
    </script>
</body>
</html>
