<?php
session_start();
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login.php");
    exit;
}
require_once "connect.php";

$phone_number = $_SESSION['phone_number'];
$user = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM members WHERE phone_number = '$phone_number'"));
$wallet_balance = $user['earning_wallet'] ?? 0;

// Get active package level
$pkg = mysqli_fetch_assoc(mysqli_query($con, "SELECT level FROM user_packages WHERE phone_number = '$phone_number'"));
$level = $pkg['level'] ?? null;

// Get package info
$package = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM packages WHERE level = '$level'"));
$task_limit = $package['task_limit'] ?? 0;
$task_rate = $package['task_rate'] ?? 0;

// Count today's tasks
$today = date("Y-m-d");
$start_of_day = "$today 00:00:00";
$end_of_day = "$today 23:59:59";

$task_result = mysqli_query($con, "SELECT * FROM user_tasks WHERE phone_number = '$phone_number' AND task_date BETWEEN '$start_of_day' AND '$end_of_day'");
$task_count_today = mysqli_num_rows($task_result);

// Process answer
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['question_id'], $_POST['answer'])) {
    $qid = intval($_POST['question_id']);
    $user_answer = trim($_POST['answer']);
    $q = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM task_questions WHERE id = '$qid'"));

    if ($q) {
        $correct = strtolower($user_answer) === strtolower($q['correct_option']) ? 1 : 0;
        $now = date("Y-m-d H:i:s");
        mysqli_query($con, "INSERT INTO user_tasks (phone_number, question_id, user_answer, is_correct, task_date) VALUES ('$phone_number', '$qid', '$user_answer', '$correct', '$now')");

        if ($correct) {
            mysqli_query($con, "UPDATE members SET earning_wallet = earning_wallet + $task_rate WHERE phone_number = '$phone_number'");
            echo "<script>
                localStorage.setItem('feedback', JSON.stringify({message: 'Correct! ₦$task_rate earned.', icon: 'success'}));
                location.href = 'task.php';
            </script>";
        } else {
            echo "<script>
                localStorage.setItem('feedback', JSON.stringify({message: 'Wrong answer. Try again tomorrow!', icon: 'error'}));
                location.href = 'task.php';
            </script>";
        }
        exit;
    }
}

// Get question if limit not reached
$question = null;
if ($task_count_today < $task_limit && $task_limit > 0) {
    $answered = mysqli_query($con, "SELECT question_id FROM user_tasks WHERE phone_number = '$phone_number' AND task_date BETWEEN '$start_of_day' AND '$end_of_day'");
    $answered_ids = [];
    while ($row = mysqli_fetch_assoc($answered)) {
        $answered_ids[] = $row['question_id'];
    }
    $exclude = implode(",", $answered_ids) ?: "0";
    $q_res = mysqli_query($con, "SELECT * FROM task_questions WHERE id NOT IN ($exclude) ORDER BY RAND() LIMIT 1");
    $question = mysqli_fetch_assoc($q_res);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Daily Task</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        body { font-family: sans-serif; margin: 0; background: #f0f8ff; }
        header { background: #007bff; color: white; padding: 1em; text-align: center; }
        .container { max-width: 600px; margin: 20px auto; background: white; padding: 20px; border-radius: 12px; box-shadow: 0 3px 10px rgba(0,0,0,0.1); }
        .circle-container {
            width: 220px; height: 220px; margin: 0 auto 20px; position: relative;
            border-radius: 50%; border: 10px solid #007bff;
            animation: spin 6s linear infinite;
        }
        .circle-container span {
            position: absolute; width: 100%; top: 50%; left: 0;
            text-align: center; transform: translateY(-50%); font-size: 20px;
        }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        .stats { display: flex; justify-content: space-between; padding: 10px 0; }
        form button { background: green; color: white; padding: 10px; border: none; border-radius: 6px; cursor: pointer; margin-top: 10px; }
        .footer { text-align: center; padding: 1em; background: #007bff; color: white; margin-top: 30px; }
    </style>
</head>
<body>
<header>Daily Task</header>
<div class="container">
    <div class="stats">
        <div><i class="fas fa-wallet"></i> Balance: ₦<?= number_format((float)$wallet_balance, 2) ?></div>
        <div><i class="fas fa-tasks"></i> <?= $task_count_today ?> / <?= $task_limit ?> tasks</div>
    </div>

    <?php if ($task_limit == 0): ?>
        <p style="color: red;">You don’t have any active task package. <a href="activate_package.php">Activate now</a>.</p>
    <?php elseif ($task_count_today >= $task_limit): ?>
        <p style="color: red;">You've reached your daily task limit.</p>
    <?php elseif ($question): ?>
        <div class="circle-container"><span><i class="fas fa-question-circle"></i></span></div>
        <p><strong><?= htmlspecialchars($question['question']) ?></strong></p>
        <form method="post">
            <input type="hidden" name="question_id" value="<?= $question['id'] ?>">
            <?php foreach (['option_a','option_b','option_c','option_d'] as $opt): ?>
                <div><input type="radio" name="answer" value="<?= $question[$opt] ?>" required> <?= $question[$opt] ?></div>
            <?php endforeach; ?>
            <button type="submit"><i class="fas fa-check"></i> Submit Answer</button>
        </form>
    <?php else: ?>
        <p>No more questions available.</p>
    <?php endif; ?>
</div>
<div class="footer">&copy; <?= date("Y") ?> City SME Project</div>

<script>
window.addEventListener('load', () => {
    const fb = localStorage.getItem('feedback');
    if (fb) {
        const { message, icon } = JSON.parse(fb);
        Swal.fire({ icon: icon, text: message });
        localStorage.removeItem('feedback');
    }
});
</script>
</body>
</html>