<?php
// Initialize the session

session_start();
 
// Check if the user is logged in, if not then redirect to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}
 
// Include config file
require_once "config.php";
 
// Define variables and initialize with empty values
$new_password = $linkfirm_password = "";
$new_password_err = $linkfirm_password_err = "";
 
// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){
 
    // Validate new password
    if(empty(trim($_POST["new_password"]))){
        $new_password_err = "Please enter the new password.";     
    } elseif(strlen(trim($_POST["new_password"])) < 6){
        $new_password_err = "Password must have atleast 6 characters.";
    } else{
        $new_password = trim($_POST["new_password"]);
    }
    
    // Validate confirm password
    if(empty(trim($_POST["confirm_password"]))){
        $linkfirm_password_err = "Please confirm the password.";
    } else{
        $linkfirm_password = trim($_POST["confirm_password"]);
        if(empty($new_password_err) && ($new_password != $linkfirm_password)){
            $linkfirm_password_err = "Password did not match.";
        }
    }
        
    // Check input errors before updating the database
    if(empty($new_password_err) && empty($linkfirm_password_err)){
        // Prepare an update statement
        $sql = "UPDATE members SET password = ? WHERE id = ?";
        
        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "si", $param_password, $param_id);
            
            // Set parameters
            $param_password = password_hash($new_password, PASSWORD_DEFAULT);
            $param_id = $_SESSION["id"];
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                // Password updated successfully. Destroy the session, and redirect to login page
                session_destroy();
                ?>
                 <script>window.top.location='login.php'</script>
                 <?php
               // header("location: login.php");
                exit();
            } else{
                echo "Oops! Something went wrong. Please try again later.";
            }
        }
        
        // Close statement
        mysqli_stmt_close($stmt);
    }
    
    // Close connection
    mysqli_close($link);
}
?>
 <?php include('header.php'); ?>
 
 
 
 
 
 <div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6 col-lg-5">
            <div class="card border-0 shadow-lg">
                <div class="card-body p-4">
                    <div class="text-center mb-4">
                        <img src="images/logoc.png" alt="Logo" style="max-height:60px;">
                  
                         <!-- Title -->
                    <h4 class="card-title text-center mb-3" style="color: #fff; background: linear-gradient(90deg, gold, black, gray); padding:8px; border-radius:6px;">
                        Reset Password
                    </h4>
                    
                        <p class="text-muted">Enter your new password below</p>
                    </div>

                    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
                        
                        <!-- New Password -->
                        <div class="form-group mb-3">
                            <input type="password" 
                                   name="new_password" 
                                   class="form-control <?php echo (!empty($new_password_err)) ? 'is-invalid' : ''; ?>" 
                                   value="<?php echo $new_password; ?>" 
                                   placeholder="New password" required>
                            <div class="invalid-feedback">
                                <?php echo $new_password_err; ?>
                            </div>
                        </div>

                        <!-- Confirm Password -->
                        <div class="form-group mb-4">
                            <input type="password" 
                                   name="confirm_password" 
                                   class="form-control <?php echo (!empty($linkfirm_password_err)) ? 'is-invalid' : ''; ?>" 
                                   placeholder="Confirm password" required>
                            <div class="invalid-feedback">
                                <?php echo $linkfirm_password_err; ?>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>

                        <!-- Back to Dashboard Link -->
                        <div class="text-center mt-3">
                            <a href="dashboard.php">&laquo; Back to Dashboard</a>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
  //// Page load preloader
  window.addEventListener("load", function() {
    document.getElementById("preloader").style.display = "none";
  });

  // Show preloader on form submit
  function showSubmitPreloader() {
    document.getElementById("preloader").style.display = "flex";
  }

  // Toggle password visibility
  function togglePassword(fieldId, icon) {
    const input = document.getElementById(fieldId);
    const isPassword = input.type === 'password';
    input.type = isPassword ? 'text' : 'password';
    icon.classList.toggle('fa-eye');
    icon.classList.toggle('fa-eye-slash');
  }
</script>



<?php include('footer.php')?>