<?php
session_start();
require_once "config.php";

$phone_number_err = $email_address_err = $password_err = "";
$success = false;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitize inputs
    $first_name = trim($_POST['first_name']);
    $last_name = trim($_POST['last_name']);
    $phone_number = trim($_POST['phone_number']);
    $email_address = trim($_POST['email_address']);
    $password = trim($_POST['password']);
    $confirm_password = trim($_POST['confirm_password']);
    $country_of_interest = 'NILL';
    $state_of_origin = 'NILL';
    $nin = 'NILL';
    $marital_status = 'NILL';
    $dob = '12042025';

    // Get sponsor from hidden input or default to 'admin'
    $sponsor_id = trim($_POST['my_sponsor']);
    if (empty($sponsor_id)) {
        $sponsor_id = "admin";
    }

    // Basic validations
    if (!filter_var($email_address, FILTER_VALIDATE_EMAIL)) {
        $email_address_err = "Invalid email format.";
    }

    if ($password !== $confirm_password) {
        $password_err = "Passwords do not match.";
    }

    // Check for duplicate phone or email
    $check_sql = "SELECT id FROM members WHERE phone_number = ? OR email_address = ?";
    $stmt = mysqli_prepare($link, $check_sql);
    mysqli_stmt_bind_param($stmt, "ss", $phone_number, $email_address);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_store_result($stmt);

    if (mysqli_stmt_num_rows($stmt) > 0) {
        $phone_number_err = "Phone number or email already exists.";
    }
    mysqli_stmt_close($stmt);

    if (empty($phone_number_err) && empty($email_address_err) && empty($password_err)) {
        // Generate unique member ID
        $member_id = substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"), 0, 10);

        $main_wallet = '';
        $earning_wallet = '';
        $email_verification_status = '1';
        $payment_status = '';
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        $insert_sql = "INSERT INTO members (
            phone_number, password, first_name, last_name, email_address,
            member_id, sponsor_id, main_wallet, earning_wallet, email_verification_status,
            payment_status, country_of_interest, state_of_origin, nin, marital_status, dob
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        if ($stmt = mysqli_prepare($link, $insert_sql)) {
            mysqli_stmt_bind_param($stmt, "ssssssssssssssss",
                $phone_number,
                $hashed_password,
                $first_name,
                $last_name,
                $email_address,
                $member_id,
                $sponsor_id,
                $main_wallet,
                $earning_wallet,
                $email_verification_status,
                $payment_status,
                $country_of_interest,
                $state_of_origin,
                $nin,
                $marital_status,
                $dob
            );

            if (mysqli_stmt_execute($stmt)) {
                $success = true;
                echo "<script>
                        window.location.href = 'login.php';
                      </script>";
                exit;
            } else {
                $password_err = "Registration failed: " . mysqli_stmt_error($stmt);
            }
            mysqli_stmt_close($stmt);
        } else {
            $password_err = "Error preparing statement: " . mysqli_error($link);
        }
    }
}
?>


<?php include('header.php')?>
    
    <!-- account section start -->
<div class="account-section bg_img" data-background="assets/images/bg/bg-5.jpg">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-xl-5 col-lg-7">
        <div class="account-card">
          <div class="account-card__header bg_img overlay--one" data-background="assets/images/bg/bg-6.jpg">
              
               <div align="center">
              <img src="images/logoc.png" alt="Logo" style="width:100px;height:auto;">
              </div>
              
            <h2 class="section-title">Join <span class="base--color">CashFuns</span></h2>
            <p>Answer questions, earn real money, and get rewarded instantly. Create your account now and start cashing in on your knowledge.</p>
          </div>
          <div class="account-card__body">
               <!-- Title -->
                    <h4 class="card-title text-center mb-3" style="color: #fff; background: linear-gradient(90deg, gold, black, gray); padding:8px; border-radius:6px;">
                        Register
                    </h4>
           

            <form class="mt-4" onsubmit="showLoader()" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">
              
              <!-- Error messages -->
              <div style="color:red; font-size:17px; text-align:center; margin-bottom:15px;">  
                <?php echo @$password_err; ?>
                <?php echo @$phone_number_err; ?>
                <?php echo @$linkfirm_password_err; ?>
                <?php echo @$email_address_err; ?>
              </div>

              <!-- First Name -->
              <div class="form-group">
                <label>First Name</label>
                <input type="text" name="first_name" class="form-control" placeholder="First Name" required>
              </div>

              <!-- Last Name -->
              <div class="form-group">
                <label>Last Name</label>
                <input type="text" name="last_name" class="form-control" placeholder="Last Name" required>
              </div>

              <!-- Phone Number -->
              <div class="form-group">
                <label>Phone Number</label>
                <input type="number" name="phone_number" class="form-control" placeholder="Phone Number" required>
              </div>

              <!-- Email -->
              <div class="form-group">
                <label>Email Address</label>
                <input type="email" name="email_address" class="form-control" placeholder="Email Address" required>
              </div>

              <!-- Country of Interest --
              <div class="form-group">
                <label>Country of Interest</label>
                <input type="text" name="country_of_interest" class="form-control" placeholder="Country of Interest" required>
              </div>

              <!-- State of Origin --
              <div class="form-group">
                <label>State of Origin</label>
                <input type="text" name="state_of_origin" class="form-control" placeholder="State of Origin" required>
              </div>

              <!-- NIN --
              <div class="form-group">
                <label>National Identity Number</label>
                <input type="text" name="nin" class="form-control" placeholder="National Identity Number" required>
              </div>

              <!-- Marital Status --
              <div class="form-group">
                <label>Marital Status</label>
                <select name="marital_status" class="form-control" required>
                  <option value="">-- Select Marital Status --</option>
                  <option value="Single">Single</option>
                  <option value="Married">Married</option>
                  <option value="Divorced">Divorced</option>
                  <option value="Widowed">Widowed</option>
                </select>
              </div>

              <!-- Date of Birth --
              <div class="form-group">
                <label>Date of Birth</label>
                <input type="date" name="dob" class="form-control" required>
              </div>

              <!-- Hidden Sponsor -->
              <input type="hidden" name="my_sponsor" value="<?php echo empty($_GET['sponsor']) ? 'admin' : htmlspecialchars($_GET['sponsor']); ?>">

              <!-- Password -->
              <div class="form-group">
                <label>Password</label>
                <div class="input-group">
                  <input type="password" name="password" id="password" class="form-control" placeholder="Password" required>
                  <div class="input-group-append">
                    <span class="input-group-text" onclick="togglePassword('password', this)"><i class="fas fa-eye"></i></span>
                  </div>
                </div>
              </div>

              <!-- Confirm Password -->
              <div class="form-group">
                <label>Confirm Password</label>
                <div class="input-group">
                  <input type="password" name="confirm_password" id="confirm_password" class="form-control" placeholder="Confirm Password" required>
                  <div class="input-group-append">
                    <span class="input-group-text" onclick="togglePassword('confirm_password', this)"><i class="fas fa-eye"></i></span>
                  </div>
                </div>
              </div>

              <!-- Remember Me -->
              <div class="form-group form-check">
                <input type="checkbox" class="form-check-input" id="rememberMe">
                <label class="form-check-label" for="rememberMe">Remember me</label>
              </div>

              <!-- Submit -->
              <div class="mt-3">
                <button type="submit" class="cmn-btn btn-block">Create Account</button>
              </div>

              <!-- Login Link -->
              <div class="text-center mt-3">
                <p class="f-size-14">Already have an account? <a href="login.php" class="base--color">Log in</a></p>
              </div>
            </form>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- account section end -->


  <div class="page-loader" id="pageLoader">
    <div class="spinner"></div>
  </div>

  <script>
    function togglePassword(fieldId, icon) {
      const input = document.getElementById(fieldId);
      const isPassword = input.type === 'password';
      input.type = isPassword ? 'text' : 'password';
      icon.classList.toggle('fa-eye');
      icon.classList.toggle('fa-eye-slash');
    }

    function showLoader() {
      document.getElementById("pageLoader").style.display = "flex";
    }
  </script>



<?php include('footer.php')?>
