<?php
session_start();
include('connect.php');

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: login.php");
    exit;
}


///////////select user details
$sql2 ="SELECT * FROM members WHERE phone_number={$_SESSION['phone_number']}";   
$result2 = mysqli_query($con, $sql2);
$data2 = mysqli_fetch_array($result2);
$first_name = $data2['first_name'];
$last_name = $data2['last_name'];
$phone_number = $data2['phone_number'];
$email_address= $data2['email_address'];
$sponsor_id= $data2['sponsor_id'];
$member_id= $data2['member_id'];
$main_wallet= $data2['main_wallet'];
$earning_wallet= $data2['earning_wallet'];
$email_verification_status= $data2['email_verification_status'];
$payment_status= $data2['payment_status'];
$package_level= $data2['package_level'];


$phone_number = $_SESSION['phone_number'];

// Pagination setup
$limit = 10;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;

// Get total number of records
$total_result = mysqli_query($con, "SELECT COUNT(*) as total FROM referral_bonus WHERE sponsor_id = '$phone_number'");
$total_row = mysqli_fetch_assoc($total_result);
$total_records = $total_row['total'];
$total_pages = ceil($total_records / $limit);

// Fetch paginated referral bonuses
$query = "SELECT * FROM referral_bonus WHERE sponsor_id = '$member_id' ORDER BY date DESC LIMIT $limit OFFSET $offset";
$result = mysqli_query($con, $query);

// Calculate total earned bonus
$sum_result = mysqli_query($con, "SELECT SUM(bonus_amount) as total_bonus FROM referral_bonus WHERE sponsor_id = '$member_id'");
$sum_row = mysqli_fetch_assoc($sum_result);
$total_bonus = $sum_row['total_bonus'] ?? 0;
?>

<!DOCTYPE html>
<html>
<head>
    <title>Referral Bonus History</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
   <style>
  body {
    font-family: 'Segoe UI', sans-serif;
    background: #1a1a1a; /* dark gray */
    margin: 0;
    color: #d4af37; /* gold text by default */
  }

  header {
    background: linear-gradient(135deg, black, #333333); /* black to dark gray gradient */
    color: #d4af37;
    padding: 15px 20px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    box-shadow: 0 2px 8px rgba(212, 175, 55, 0.6);
  }

  header h1 {
    margin: 0;
    font-size: 22px;
    color: #d4af37;
    text-shadow: 0 0 5px #d4af37;
  }

  .hamburger {
    font-size: 24px;
    cursor: pointer;
    display: none;
    color: #d4af37;
  }

  nav {
    background: linear-gradient(135deg, #000000, #222222);
    color: #d4af37;
    padding: 10px 20px;
    box-shadow: inset 0 -2px 5px rgba(212, 175, 55, 0.3);
  }

  .nav-links {
    display: flex;
    gap: 15px;
  }

  .nav-links a {
    color: #d4af37;
    text-decoration: none;
    font-weight: bold;
    transition: color 0.3s ease;
  }

  .nav-links a:hover {
    color: #ffd700; /* brighter gold on hover */
  }

  .nav-links a i {
    margin-right: 5px;
  }

  .container {
    max-width: 800px;
    margin: 30px auto;
    background: #222222; /* dark gray container */
    padding: 25px;
    border-radius: 8px;
    box-shadow: 0 0 12px rgba(212, 175, 55, 0.6);
    color: #d4af37;
  }

  h2 {
    text-align: center;
    color: white;
    text-shadow: 0 0 5px #d4af37;
  }

  .total-box {
    background: #333333;
    border: 2px solid #d4af37;
    color: #d4af37;
    font-size: 20px;
    padding: 15px;
    margin-bottom: 20px;
    border-radius: 10px;
    text-align: center;
    box-shadow: 0 0 10px rgba(212, 175, 55, 0.4);
  }

  table {
    width: 100%;
    border-collapse: collapse;
  }

  th, td {
    padding: 12px;
    text-align: center;
    border-bottom: 1px solid #555555;
  }

  th {
    background: linear-gradient(135deg, #000000, #333333);
    color: #d4af37;
    text-shadow: 0 0 5px #d4af37;
  }

  .pagination {
    margin-top: 25px;
    text-align: center;
  }

  .pagination a {
    margin: 0 5px;
    color: #d4af37;
    padding: 8px 12px;
    text-decoration: none;
    border: 1px solid #d4af37;
    border-radius: 4px;
    transition: background 0.3s ease, color 0.3s ease;
  }

  .pagination a.active {
    background-color: #d4af37;
    color: #222222;
    box-shadow: 0 0 8px #ffd700;
  }

  .pagination a:hover {
    background: #ffd700;
    color: #222222;
    box-shadow: 0 0 12px #ffd700;
  }

  @media (max-width: 768px) {
    .nav-links {
      display: none;
      flex-direction: column;
      background: linear-gradient(135deg, #000000, #222222);
      width: 100%;
      box-shadow: 0 4px 10px rgba(212, 175, 55, 0.3);
    }

    .nav-links.active {
      display: flex;
    }

    .hamburger {
      display: block;
    }
  }
</style>

</head>
<body>

<header>
    <h1><i class="fas fa-hand-holding-usd"></i> Referral History</h1>
    <div class="hamburger" onclick="toggleMenu()"><i class="fas fa-bars"></i></div>
</header>

<nav>
    <div class="nav-links" id="navLinks">
        <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
        <!--<a href="#"><i class="fas fa-wallet"></i> Wallet</a>
        <a href="#"><i class="fas fa-users"></i> Referrals</a>--->
        <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>
</nav>

<div class="container">
    <h2>Your Referral Bonuses</h2>

    <div class="total-box">
        <strong>Total Referral Bonus Earned:</strong> ₦<?= number_format($total_bonus, 2) ?>
    </div>

    <?php if (mysqli_num_rows($result) > 0): ?>
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Referral Phone</th>
                    <th>Bonus Amount</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                <?php $sn = $offset + 1; ?>
                <?php while ($row = mysqli_fetch_assoc($result)): ?>
                    <tr>
                        <td><?= $sn++ ?></td>
                        <td><?= htmlspecialchars($row['member_phone']) ?></td>
                        <td>₦<?= number_format($row['bonus_amount'], 2) ?></td>
                        <td><?= date('d M Y h:i A', strtotime($row['date'])) ?></td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>

        <div class="pagination">
            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <a class="<?= $i === $page ? 'active' : '' ?>" href="?page=<?= $i ?>"><?= $i ?></a>
            <?php endfor; ?>
        </div>

    <?php else: ?>
        <p style="text-align: center; font-size: 18px; color: #888;">No referral bonus yet.</p>
    <?php endif; ?>
</div>

<script>
    function toggleMenu() {
        document.getElementById("navLinks").classList.toggle("active");
    }
</script>

</body>
</html>
