<?php
/*
session_start();
include("connect.php");

$phone_number = $_SESSION['phone_number'] ?? '';
if (!$phone_number) {
    header("Location: login.php");
    exit();
}
*/

session_start();
include('connect.php');

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login.php");
    exit;
}

$phone_number = $_SESSION['phone_number'];


//////////////////////pop up message//////////////
$popupResult = mysqli_query($con, "SELECT message FROM popup_messages ORDER BY id DESC LIMIT 1");
$popupRow = mysqli_fetch_assoc($popupResult);
$popupMessage = $popupRow['message'] ?? '';

$popupStatusResult = mysqli_query($con, "SELECT popup_shown FROM members WHERE phone_number = '$phone_number'");
$popupShownRow = mysqli_fetch_assoc($popupStatusResult);
$popupShown = $popupShownRow['popup_shown'];

if ($popupShown == 0 && !empty($popupMessage)) {
    echo "
    <div id='popupBox' style='
        position: fixed; top: 20%; left: 50%; transform: translateX(-50%);
        background: white; border: 2px solid #007bff; border-radius: 10px;
        box-shadow: 0 0 10px rgba(0,0,0,0.3); padding: 20px; z-index: 9999; max-width: 90%;'>
        <p style='font-size: 16px;'>$popupMessage</p>
        <button onclick='closePopup()' style='background: #007bff; color: white; border: none; padding: 10px 15px; border-radius: 5px;'>Close</button>
    </div>
    <script>
        function closePopup() {
            document.getElementById('popupBox').style.display = 'none';
            // Notify server to update user status
            fetch('update_popup_status.php', { method: 'POST' });
        }
    </script>";
}

////////////////pop message//end////////////////


// Member info
$member_result = mysqli_query($con, "SELECT * FROM members WHERE phone_number = '$phone_number'");
$member = mysqli_fetch_assoc($member_result);

if($member['main_wallet']>0){
$main_wallet = number_format($member['main_wallet'], 2);
}
else{
$main_wallet = $member['main_wallet'];   
}
if($member['earning_wallet']>0){
$earning_wallet = number_format($member['earning_wallet'], 2);
}
else{
$earning_wallet = $member['earning_wallet'];
}
$member_id = $member['member_id'];


$stats_result = mysqli_query($con, "SELECT 
    (SELECT COUNT(*) FROM user_tasks WHERE phone_number = '$phone_number') as total_tasks,
    (SELECT COUNT(*) FROM user_tasks WHERE phone_number = '$phone_number' AND is_correct = 1) as correct_answers,
    (SELECT COUNT(*) FROM user_tasks WHERE phone_number = '$phone_number' AND is_correct = 0) as wrong_answers
");
$stats = mysqli_fetch_assoc($stats_result);

$pkg_query = "SELECT p.package_name 
              FROM user_packages up 
              JOIN packages p ON p.level = up.level 
              WHERE up.phone_number = '$phone_number'";
$pkg_result = mysqli_query($con, $pkg_query);
$active_package = mysqli_num_rows($pkg_result) > 0 ? mysqli_fetch_assoc($pkg_result)['package_name'] : "None";

$package_result = mysqli_query($con, "SELECT * FROM packages ORDER BY id ASC LIMIT 6");
$icons = ["fa-rocket", "fa-gem", "fa-fire", "fa-bolt", "fa-star", "fa-diamond"];
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Dashboard - City SME Projects</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;700&display=swap" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Nunito', sans-serif; }
    body { background: #f4faff; color: #333; }

    header, footer { background: #007BFF; color: white; text-align: center; padding: 1rem; }
    .logo { width: 50px; }

    .hamburger { display: none; font-size: 24px; cursor: pointer; }

    nav ul { display: flex; justify-content: left; list-style: none; padding-left: 1rem; gap: 1rem; }
    nav a { color: white; text-decoration: none; font-weight: bold; }

    @media (max-width: 768px) {
      .hamburger { display: block; position: absolute; left: 1rem; top: 1rem; }
      nav ul { display: none; flex-direction: column; background: #0056b3; position: absolute; top: 60px; width: 100%; left: 0; }
      nav ul.show { display: flex; }
    }

    .wallets, .stats, .packages { padding: 1rem; display: grid; gap: 1rem; }
    .wallets, .stats { grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); }

    .card {
      background: white;
      padding: 1rem;
      border-radius: 1rem;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
      text-align: center;
    }

    .card h3 { color: #007BFF; margin-bottom: .5rem; }
    .card p { font-size: 1.2rem; font-weight: bold; }

    .packages {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 1rem;
    }

    .package-card {
      background: linear-gradient(to bottom right, #007bff, #00c6ff);
      color: white;
      padding: 1rem;
      border-radius: 1rem;
      transition: transform 0.3s;
      text-align: left;
    }

    .package-card:hover { transform: translateY(-5px); }

    .package-card h3 { font-size: 1rem; margin-bottom: 0.5rem; }
    .package-card p { font-size: 1rem; }

    .package-card a {
      display: inline-block;
      margin-top: 0.5rem;
      background: white;
      color: #007bff;
      padding: 0.4rem 0.8rem;
      border-radius: 0.5rem;
      text-decoration: none;
      font-weight: bold;
    }

    .marquee {
      background: #e9f2ff;
      padding: .5rem 1rem;
      color: #007BFF;
      overflow: hidden;
      white-space: nowrap;
    }

    .marquee-content {
      display: inline-block;
      animation: marquee 10s linear infinite;
    }

    @keyframes marquee {
      0% { transform: translateX(100%); }
      100% { transform: translateX(-100%); }
    }

    .preloader {
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background: white;
      z-index: 9999;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .preloader .fa-spinner {
      font-size: 3rem;
      color: #007BFF;
      animation: spin 2s linear infinite;
    }

    @keyframes spin { 100% { transform: rotate(360deg); } }

    .btn-group {
      display: flex;
      justify-content: center;
      gap: 1rem;
      padding: 1rem;
    }

    .btn-group a {
      background: #007BFF;
      color: white;
      padding: 0.6rem 1rem;
      border-radius: 0.5rem;
      text-decoration: none;
      font-weight: bold;
      transition: background 0.3s;
    }

    .btn-group a:hover { background: #0056b3; }

    .show-more {
      text-align: center;
      padding: 1rem;
    }

    .show-more a {
      background: #007BFF;
      color: white;
      padding: 0.5rem 1rem;
      border-radius: 0.5rem;
      text-decoration: none;
    }

    .referral-section {
      text-align: center;
      margin: 1rem;
      padding: 1rem;
      background: #fff;
      border-radius: 1rem;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }

    .referral-section input {
      width: 80%;
      padding: 0.6rem;
      border: 1px solid #ccc;
      border-radius: 0.5rem;
      margin-bottom: 0.5rem;
      font-size: 1rem;
      text-align: center;
    }

    .referral-section button {
      background: #007BFF;
      color: white;
      padding: 0.5rem 1rem;
      border: none;
      border-radius: 0.5rem;
      cursor: pointer;
      font-weight: bold;
    }

    .referral-section button:hover {
      background: #0056b3;
    }
  </style>
</head>
<body>

<div class="preloader"><i class="fas fa-spinner"></i></div>

<header>
  <img src="logoc.png" alt="City SME Logo" class="logo">
  <h1>City SME Projects</h1>
  <p>Answer questions, Earn, Grow</p>
  <div class="hamburger" onclick="toggleMenu()"><i class="fas fa-bars"></i></div>
  <nav>
    <ul id="menu">
      <li><a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a></li>
      <li><a href="task.php"><i class="fas fa-question-circle"></i> Start Tasks</a></li>
      <li><a href="deposit.php"><i class="fas fa-question-circle"></i> Deposit</a></li>
      <li><a href="packages.php"><i class="fas fa-question-circle"></i> Packages</a></li>
      <li><a href="withdrawal.php"><i class="fas fa-money-bill"></i> Withdraw</a></li>
      <li><a href="withdrawal_history.php"><i class="fas fa-money-bill"></i> Withdrawal History</a></li>
      <li><a href="referral_history.php"><i class="fas fa-users"></i> Referrals</a></li>
      <li><a href="#"><i class="fas fa-question-circle"></i> Reset Password</a></li>
      <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
    </ul>
  </nav>
</header>

<div class="marquee"><div class="marquee-content">Welcome back, <?php echo $member['first_name']; ?>! Let’s earn today with City SME Projects!</div></div>

<section class="wallets">
  <div class="card">
    <h3>Main Wallet</h3>
    <p><i class="fas fa-wallet"></i> ₦<?php echo $main_wallet; ?></p>
  </div>
  <div class="card">
    <h3>Earning Wallet</h3>
    <p><i class="fas fa-coins"></i> ₦<?php echo $earning_wallet; ?></p>
  </div>
</section>


<section class="stats">
  <div class="card"><h3>Active Package</h3><p><i class="fas fa-box"></i> <?php echo $active_package; ?></p></div>
  <div class="card"><h3>Total Tasks Attempt</h3><p><i class="fas fa-tasks"></i> <?php echo $stats['total_tasks']; ?></p></div>
  <div class="card"><h3>Correct Answers</h3><p><i class="fas fa-check-circle"></i> <?php echo $stats['correct_answers']; ?></p></div>
  <div class="card"><h3>Wrong Answers</h3><p><i class="fas fa-times-circle"></i> <?php echo $stats['wrong_answers']; ?></p></div>
</section>

<div class="btn-group">
  <a href="deposit.php"><i class="fas fa-arrow-down"></i> Deposit</a>
  <a href="withdrawal.php"><i class="fas fa-arrow-up"></i> Withdraw</a>
  <a href="task.php"><i class="fas fa-play-circle"></i> Start Task</a>
</div>


<!-- REFERRAL SECTION -->
<div class="referral-section">
 
  <input type="text" id="referralLink" value="https://citysmeproject.com/register.php?sponsor=<?php echo $member_id; ?>" readonly>
  <button onclick="copyReferralLink()"><i class="fas fa-copy"></i> Copy Referral Link</button>
</div>


<section class="packages">
<?php $icon_index = 0; while ($pkg = mysqli_fetch_assoc($package_result)):
    $icon = $icons[$icon_index % count($icons)];
    $icon_index++;
?>
  <div class="package-card">
    <h3><i class="fas <?php echo $icon; ?>"></i> <?php echo $pkg['package_name']; ?></h3>
    <p>Activate Fee: ₦<?php echo number_format($pkg['activation_amount'], 2); ?></p>
    <p>Daily Tasks: <?php echo $pkg['task_limit']; ?></p>
    <p>Daily Earnings: ₦<?php echo number_format($pkg['task_limit'] * $pkg['task_rate'], 2); ?></p>
    <a href="activate_package.php?id=<?php echo $pkg['id']; ?>">Activate</a>
  </div>
<?php endwhile; ?>
</section>

<div class="show-more">
  <a href="packages.php"><i class="fas fa-layer-group"></i> Show More Packages</a>
</div>

<footer>
  &copy; <?php echo date("Y"); ?> City SME Projects. All rights reserved.
</footer>

<script>
function toggleMenu() {
  document.getElementById('menu').classList.toggle('show');
}

window.addEventListener('load', () => {
  document.querySelector('.preloader').style.display = 'none';
});

function copyReferralLink() {
  const input = document.getElementById("referralLink");
  input.select();
  input.setSelectionRange(0, 99999); 
  document.execCommand("copy");

  Swal.fire({
    icon: 'success',
    title: 'Copied!',
    text: 'Your referral link has been copied.',
    confirmButtonColor: '#007BFF'
  });
}
</script>

 <script>var mobile=+2348050361477;</script><script src="https://samorabot.com/addchat/loadchat.js"></script><meta name="apple-mobile-web-app-capable" content="yes">
 
</body>
</html>