<?php
// Initialize the session
session_start();
 
// Check if the user is logged in, if not then redirect him/her to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}



include 'connect.php';

include 'menu.php';


if (!isset($_GET['id'])) {
    die("No ID provided.");
}

$id = $_GET['id'];
$stmt = $con->prepare("SELECT * FROM packages WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$package = $result->fetch_assoc();

if (!$package) {
    die("Package not found.");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>View Package</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <link
  href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css"
  rel="stylesheet"
/>

</head>
<body>
<div class="container mt-5">
    <a href="package_list.php" class="btn btn-secondary mb-3">← Back</a>
    <div class="card p-4">
         <!--<img src="logoc.png" style="width:120px;height:auto;" alt="Logo" />--->
         <br>
        <h4>Package Details</h4>
        <ul class="list-group">
            <li class="list-group-item"><strong>Name:</strong> <?= htmlspecialchars($package['package_name']) ?></li>
            <li class="list-group-item"><strong>Activation Amount:</strong> ₦<?= number_format($package['activation_amount'], 2) ?></li>
            <li class="list-group-item"><strong>Task Rate:</strong> ₦<?= number_format($package['task_rate'], 2) ?></li>
            <li class="list-group-item"><strong>Task Limit:</strong> <?= $package['task_limit'] ?></li>
        </ul>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


</body>
</html>
