<?php
// Initialize the session
session_start();
 
// Check if the user is already logged in, if yes then redirect him to welcome page

/*
if(isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true){
    header("location: index.php");
    exit;
}
 */
 
 
 include('config.php');

//////////////forgot password buton////////////////////////
if(isset($_POST['forgot_password'])){?>
<script>window.top.location='forgot_password.php'</script>
<?php
} 
/////////////////////////


// Define variables and initialize with empty values
$phone_number = $password = "";
$phone_number_err = $password_err = "";
 
// Processing form data when form is submitted
if(isset($_POST['submit'])){
 
    // Check if phone_number is empty
    if(empty(trim($_POST["phone_number"]))){
        $phone_number_err = "Please enter phone number.";
    } else{
        $phone_number = trim($_POST["phone_number"]);
    }
    
    // Check if password is empty
    if(empty(trim($_POST["password"]))){
        $password_err = "Please enter your password.";
    } else{
        $password = trim($_POST["password"]);
    }
    
    // Validate credentials
    if(empty($phone_number_err) && empty($password_err)){
        // Prepare a select statement
        $sql = "SELECT id, phone_number, password FROM admin WHERE phone_number = ?";
        
        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "s", $param_phone_number );
            
            // Set parameters
            $param_phone_number = $phone_number;
			
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                // Store result
                mysqli_stmt_store_result($stmt);
                
                // Check if phone_number exists, if yes then verify password
                if(mysqli_stmt_num_rows($stmt) == 1){                    
                    // Bind result variables
                    mysqli_stmt_bind_result($stmt, $id, $phone_number,  $hashed_password);
                    if(mysqli_stmt_fetch($stmt)){
                        if(password_verify($password, $hashed_password)){
                            // Password is correct, so start a new session
                            session_start();
                            
                            // Store data in session variables
                            $_SESSION["loggedin"] = true;
                            $_SESSION["id"] = $id;
                            $_SESSION["phone_number"] = $phone_number;                            
                            
                            // Redirect user to welcome page
                            ?>
                            <script>window.top.location='dashboard.php'</script>
                            <?php
                           
                        } else{
                            // Display an error message if password is not valid
                            $password_err = "The password you entered was not valid.";
                        }
                    }
                } else{
                    // Display an error message if phone_number doesn't exist
                    $phone_number_err = "No account found with that phone number.";
                }
            } else{
                echo "Oops! Something went wrong. Please try again later.";
            }
        }
        
        // Close statement
        mysqli_stmt_close($stmt);
    }
    
    // Close connection
    mysqli_close($link);
}
?>







<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Login</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
  * {
    box-sizing: border-box;
  }
  body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: linear-gradient(135deg, #1a1a1a, #333333);
    margin: 0;
    padding: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    min-height: 100vh;
    position: relative;
    color: #d4af37; /* gold text default */
  }

  .preloader {
    position: fixed;
    top: 0; left: 0;
    width: 100%;
    height: 100%;
    background: #111;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
  }

  .spinner {
    border: 5px solid #555;
    border-top: 5px solid gold;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    animation: spin 1s linear infinite;
  }

  @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
  }

  .container {
    background: linear-gradient(145deg, #222, #111);
    padding: 30px;
    max-width: 400px;
    width: 90%;
    border-radius: 15px;
    box-shadow: 0 0 20px rgba(212, 175, 55, 0.8);
    text-align: center;
    color: #d4af37;
  }

  .container img {
    width: 150px;
    height: auto;
    margin: 0 auto 20px;
    display: block;
    filter: drop-shadow(0 0 5px gold);
  }

  .form-group {
    position: relative;
    margin-bottom: 20px;
    text-align: left;
  }

  .form-group label {
    display: block;
    margin-bottom: 5px;
    color: #d4af37;
    font-weight: 600;
  }

  .form-group input {
    width: 100%;
    padding: 10px 35px 10px 35px;
    border: 1px solid #555;
    border-radius: 8px;
    outline: none;
    background: #222;
    color: #d4af37;
    transition: border 0.3s, box-shadow 0.3s;
  }

  .form-group input::placeholder {
    color: #aaa;
  }

  .form-group input:focus {
    border-color: gold;
    box-shadow: 0 0 8px rgba(212, 175, 55, 0.8);
    background: #1a1a1a;
    color: #ffd700;
  }

  .form-group i.fa-user,
  .form-group i.fa-lock {
    position: absolute;
    left: 10px;
    top: 50%;
    transform: translateY(-50%);
    color: gold;
  }

  .form-group .toggle-password {
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-50%);
    cursor: pointer;
    color: #d4af37;
    opacity: 0.7;
    transition: opacity 0.3s;
  }

  .form-group .toggle-password:hover {
    opacity: 1;
  }

  .form-check {
    margin-bottom: 15px;
    text-align: left;
    color: #d4af37;
  }

  .btn {
    width: 100%;
    padding: 10px;
    background: linear-gradient(90deg, gold, #b8860b);
    color: #000;
    border: none;
    border-radius: 8px;
    font-weight: bold;
    cursor: pointer;
    margin-top: 10px;
    box-shadow: 0 3px 10px rgba(212, 175, 55, 0.7);
    transition: background 0.3s ease, color 0.3s ease;
  }

  .btn:hover {
    background: linear-gradient(90deg, #ffd700, #d4af37);
    color: #111;
  }

  .error-message {
    color: #ff5555;
    font-size: 15px;
    margin-bottom: 15px;
    font-weight: 600;
  }

  .footer {
    text-align: center;
    margin-top: 20px;
    font-size: 14px;
    color: gold;
  }
</style>

</head>
<body>

<!-- Preloader -->
<div class="preloader" id="preloader">
  <div class="spinner"></div>
   <h4> Admin Login</h4>
</div>

<div class="container">
  <img src="images/logoc.png" alt="Logo" />
  
 <h3> Admin Login</h3>
  <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" onsubmit="showSubmitPreloader()">
    
    <div class="error-message">
      <?php echo @$password_err; ?>
      <?php echo @$phone_number_err; ?>
    </div>

    <div class="form-group">
      <label for="phone_number">Phone Number</label>
      <i class="fas fa-user"></i>
      <input type="text" name="phone_number" id="phone_number" placeholder="Phone Number" required />
    </div>

    <div class="form-group">
      <label for="password">Password</label>
      <i class="fas fa-lock"></i>
      <input type="password" name="password" id="password" placeholder="Password" required />
      <i class="fas fa-eye toggle-password" onclick="togglePassword('password', this)"></i>
    </div>

    <div class="form-check">
      <label><input type="checkbox" /> Remember me</label>
    </div>

    <button type="submit" name="submit" class="btn">Log In</button>
    <button type="submit" name="forgot_password" class="btn" style="margin-top: 10px;">Forgot Password?</button>
  </form>
  
  <div class="footer">
  <p style="color:black;font-size:10px;">Copyright 2025 &copy; Cashfunz | All Rights Reserved</p>
</div>

</div>


<script>
  /// Page load preloader
  window.addEventListener("load", function() {
    document.getElementById("preloader").style.display = "none";
  });

  // Show preloader on form submit
  function showSubmitPreloader() {
    document.getElementById("preloader").style.display = "flex";
  }

  // Toggle password visibility
  function togglePassword(fieldId, icon) {
    const input = document.getElementById(fieldId);
    const isPassword = input.type === 'password';
    input.type = isPassword ? 'text' : 'password';
    icon.classList.toggle('fa-eye');
    icon.classList.toggle('fa-eye-slash');
  }
</script>
</body>
</html>