<?php
// Initialize the session
session_start();
 
// Check if the user is logged in, if not then redirect him/her to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}

include 'connect.php';

include 'menu.php';


$deleted = false;
if (isset($_GET['id'])) {
    $id = intval($_GET['id']);

    // Delete query
    $stmt = $con->prepare("DELETE FROM packages WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        $deleted = true;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Delete Package</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <link
  href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css"
  rel="stylesheet"
/>
    <style>
        body { background-color: #f4f6f8; }
        .container { max-width: 500px; margin-top: 100px; text-align: center; }
        .card { padding: 30px; border-radius: 12px; box-shadow: 0 5px 15px rgba(0,0,0,0.1); }
        .logo { max-height: 60px; margin-bottom: 20px; }
    </style>
</head>
<body>

<div class="container">
    <div class="card">
        <img src="logoc.png" style="width:150px;height:auto;" alt="Logo">

        <?php if ($deleted): ?>
            <h4 class="text-success">Package deleted successfully!</h4>
        <?php else: ?>
            <h4 class="text-danger">Failed to delete package or invalid ID.</h4>
        <?php endif; ?>

        <a href="package_list.php" class="btn btn-primary mt-4">← Back to Package List</a>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


</body>
</html>
