<?php
// Database connection
// Initialize the session
session_start();

// Check if the user is logged in, if not then redirect him/her to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}

include('connect.php');
include 'menu.php';

$success = $error = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $package_name = trim($_POST["package_name"]);
    $activation_amount = $_POST["activation_amount"];
    $task_rate = $_POST["task_rate"];
    $task_limit = $_POST["task_limit"];
    $duration = $_POST["duration"]; // New duration input

    // Get highest existing level
    $level_result = mysqli_query($con, "SELECT MAX(level) AS max_level FROM packages");
    $level_row = mysqli_fetch_assoc($level_result);
    $next_level = $level_row['max_level'] ? $level_row['max_level'] + 1 : 1;

    // Prepare insert with duration
    $stmt = $con->prepare("INSERT INTO packages (package_name, activation_amount, task_rate, task_limit, duration, level) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sddiii", $package_name, $activation_amount, $task_rate, $task_limit, $duration, $next_level);

    if ($stmt->execute()) {
        $success = "Package created successfully.";
    } else {
        $error = "Error: " . $stmt->error;
    }

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Create Package</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body {
            background: #1c1c1c;
            color: #d4af37;
            font-family: 'Segoe UI', sans-serif;
        }
        .form-container {
            max-width: 600px;
            margin: 50px auto;
            background: linear-gradient(145deg, #2e2e2e, #1a1a1a);
            padding: 30px;
            border-radius: 16px;
            box-shadow: 0 8px 20px rgba(212, 175, 55, 0.5);
            color: #d4af37;
        }
        .card {
            border-radius: 16px;
            box-shadow: 0 8px 16px rgba(212, 175, 55, 0.3);
            background: #222;
            padding: 20px;
            color: #ffd700;
        }
        .logo {
            width: 150px;
            height: auto;
            margin: 0 auto 20px;
            display: block;
            filter: drop-shadow(0 0 6px #d4af37);
        }
    </style>
</head>
<body>
    <div class="container form-container">
        <div class="card p-4">
            <img src="images/logoc.png" class="logo" alt="Logo" />
            <h2 class="text-center mb-4">Create New Package</h2>
            <?php if ($success): ?>
                <div class="alert alert-success"><?= $success ?></div>
            <?php elseif ($error): ?>
                <div class="alert alert-danger"><?= $error ?></div>
            <?php endif; ?>
            <form method="post" action="">
                <div class="mb-3">
                    <label for="package_name" class="form-label">Package Name</label>
                    <input type="text" class="form-control" id="package_name" name="package_name" required />
                </div>
                <div class="mb-3">
                    <label for="activation_amount" class="form-label">Activation Amount (₦)</label>
                    <input type="number" step="0.01" class="form-control" id="activation_amount" name="activation_amount" required />
                </div>
                <div class="mb-3">
                    <label for="task_rate" class="form-label">Task Rate (₦)</label>
                    <input type="number" step="0.01" class="form-control" id="task_rate" name="task_rate" required />
                </div>
                <div class="mb-3">
                    <label for="task_limit" class="form-label">Daily Task Limit</label>
                    <input type="number" class="form-control" id="task_limit" name="task_limit" required />
                </div>
                <div class="mb-3">
                    <label for="duration" class="form-label">Duration</label>
                    <select class="form-select" id="duration" name="duration" required>
                        <option value="" selected disabled>Select duration</option>
                        <?php
                        // Generate options 1 to 180 days
                        for ($i = 1; $i <= 180; $i++) {
                            $text = $i . ($i == 1 ? " day" : " days");
                            echo "<option value=\"$i\">$text</option>";
                        }
                        ?>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary w-100">Create Package</button>
            </form>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
