<?php
// billing.php

session_start();
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login.php");
    exit;
}

include('env-helper.php');

include('connect.php');



// -----------------------------
// Basic Input Sanitization
// -----------------------------
$email = isset($_GET['email']) ? trim($_GET['email']) : '';
$activation_fee = isset($_GET['amount']) ? floatval($_GET['amount']) : 0;
$ref = isset($_GET['payment_reference']) ? trim($_GET['payment_reference']) : '';

if ($activation_fee <= 0 || !$email || !$ref) {
    die('Invalid payment request');
}

// Check session phone number
$phone_number = $_SESSION['phone_number'] ?? '';
if (!$phone_number) {
    die('Missing session phone number');
}

// -----------------------------
// Verify user existence
// -----------------------------
$stmt = $con->prepare("SELECT phone_number FROM members WHERE phone_number = ?");
$stmt->bind_param("s", $phone_number);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$user) {
    die('User not found');
}

// -----------------------------
// Update member with reference & intended amount
// -----------------------------
$stmt = $con->prepare("UPDATE members SET payment_reference = ?, attempt_payment_amount = ? WHERE phone_number = ?");
$stmt->bind_param("sds", $ref, $activation_fee, $phone_number);
$stmt->execute();
$stmt->close();

// -----------------------------
// Paystack Payment Init
// -----------------------------
$callback_url = 'https://cashfunz.com/payment_call_back_22ab.php';

// Load Paystack secret key from .env file
$paystack_secret = getEnvValue('PAYSTACK_DEPOSIT_SECRET');
if (!$paystack_secret) {
    die('Paystack secret not configured in .env file');
}

$payload = [
    'amount'       => (int) round($activation_fee * 100), // in Kobo
    'email'        => $email,
    'reference'    => $ref,
    'callback_url' => $callback_url,
    'metadata'     => [
        'custom_fields' => [
            [
                'display_name' => 'Phone Number',
                'variable_name' => 'phone_number',
                'value' => $phone_number
            ]
        ]
    ]
];


// CURL Request to Paystack
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => "https://api.paystack.co/transaction/initialize",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_HTTPHEADER => [
        "authorization: Bearer {$paystack_secret}",
        "content-type: application/json"
    ],
    CURLOPT_TIMEOUT => 60
]);

$response = curl_exec($ch);
$err = curl_error($ch);
curl_close($ch);

if ($err) {
    die('Curl returned error: ' . $err);
}

$tranx = json_decode($response, true);
if (!$tranx || empty($tranx['status'])) {
    die('API returned error: ' . ($tranx['message'] ?? 'Unknown error'));
}

// -----------------------------
// Redirect to Paystack Checkout
// -----------------------------
header('Location: ' . $tranx['data']['authorization_url']);
exit;
