<?php
// Start session
session_start();

// Enable error reporting (for debugging - remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include database connection
include('connect.php');

// Check if the user is logged in
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: ../index.php");
    exit;
}

// Restrict access to specific phone number
$phone = $_SESSION['phone_number'] ?? '';
if ($phone !== "07017277045" && $phone !== "08101399064") {
    header("location: ../index.php");
    exit;
}


// Define and initialize variables
$first_name = $last_name = $phone_number = $email_address = $password = $member_id = $sponsor_id = $confirm_password = "";
$first_name_err = $last_name_err = $phone_number_err = $email_address_err = $password_err = $member_id_err = $sponsor_id_err = $confirm_password_err = "";

// Form submission logic
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Generate random referral/member ID
    function GeraHash($qtd) {
        $Caracteres = '1234567890';
        $QuantidadeCaracteres = strlen($Caracteres);
        $QuantidadeCaracteres--;
        $Hash = NULL;
        for ($x = 1; $x <= $qtd; $x++) {
            $Posicao = rand(0, $QuantidadeCaracteres);
            $Hash .= substr($Caracteres, $Posicao, 1);
        }
        return $Hash;
    }
    $member_id = GeraHash(9);

    // Sanitize input
    $first_name = htmlspecialchars(stripslashes(trim($_POST["first_name"] ?? "")));
    $last_name = htmlspecialchars(stripslashes(trim($_POST["last_name"] ?? "")));
    $phone_number = htmlspecialchars(stripslashes(trim($_POST["phone_number"] ?? "")));
    $email_address = htmlspecialchars(stripslashes(trim($_POST["email_address"] ?? "")));
    $password = trim($_POST["password"] ?? "");
    $confirm_password = trim($_POST["confirm_password"] ?? "");
    $sponsor_id = htmlspecialchars(stripslashes(trim($_POST["my_sponsor"] ?? "admin")));

    // Validate first name
    if (empty($first_name)) {
        $first_name_err = "Please enter your first name.";
    }

    // Validate last name
    if (empty($last_name)) {
        $last_name_err = "Please enter your last name.";
    }

    // Validate phone number
    if (empty($phone_number)) {
        $phone_number_err = "Please enter phone number.";
    } else {
        $sql = "SELECT id FROM admin WHERE phone_number = ?";
        if ($stmt = mysqli_prepare($con, $sql)) {
            mysqli_stmt_bind_param($stmt, "s", $phone_number);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_store_result($stmt);
            if (mysqli_stmt_num_rows($stmt) >= 1) {
                $phone_number_err = "This phone number is already registered.";
            }
            mysqli_stmt_close($stmt);
        }
    }

    // Validate email
    if (empty($email_address)) {
        $email_address_err = "Please enter an email address.";
    } else {
        $sql = "SELECT id FROM admin WHERE email_address = ?";
        if ($stmt = mysqli_prepare($con, $sql)) {
            mysqli_stmt_bind_param($stmt, "s", $email_address);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_store_result($stmt);
            if (mysqli_stmt_num_rows($stmt) == 1) {
                $email_address_err = "This email address is already taken.";
            }
            mysqli_stmt_close($stmt);
        }
    }

    // Validate password
    if (empty($password)) {
        $password_err = "Please enter a password.";
    } elseif (strlen($password) < 6) {
        $password_err = "Password must have at least 6 characters.";
    }

    // Validate confirm password
    if (empty($confirm_password)) {
        $confirm_password_err = "Please confirm password.";
    } elseif ($password !== $confirm_password) {
        $confirm_password_err = "Passwords do not match.";
    }

    // If all validations pass
    if (empty($first_name_err) && empty($last_name_err) && empty($phone_number_err) && empty($email_address_err) && empty($password_err) && empty($confirm_password_err)) {

        $sql = "INSERT INTO admin (
            phone_number,
            password,
            first_name,
            last_name,
            email_address,
            member_id,
            sponsor_id,
            referral_wallet,
            earning_wallet,
            email_verification_status,
            payment_status
        ) VALUES (?, ?, ?, ?, ?, ?, ?, '', '', '', '')";

        if ($stmt = mysqli_prepare($con, $sql)) {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);

            mysqli_stmt_bind_param($stmt, "sssssss",
                $phone_number,
                $hashed_password,
                $first_name,
                $last_name,
                $email_address,
                $member_id,
                $sponsor_id
            );

            if (mysqli_stmt_execute($stmt)) {
                // Registration successful
                echo "<script>alert('Registration successful!'); window.location='login.php';</script>";
                exit;
            } else {
                echo "❌ Insert Error: " . mysqli_stmt_error($stmt);
            }
            mysqli_stmt_close($stmt);
        } else {
            echo "❌ Prepare Error: " . mysqli_error($con);
        }
    } else {
        // Show validation errors
        echo "<ul style='color:red;'>";
        if ($first_name_err) echo "<li>$first_name_err</li>";
        if ($last_name_err) echo "<li>$last_name_err</li>";
        if ($phone_number_err) echo "<li>$phone_number_err</li>";
        if ($email_address_err) echo "<li>$email_address_err</li>";
        if ($password_err) echo "<li>$password_err</li>";
        if ($confirm_password_err) echo "<li>$confirm_password_err</li>";
        echo "</ul>";
    }

    // Close DB connection
    mysqli_close($con);
}
?>

<!----------------include header--------------------->

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Register</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
 <style>
  body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: linear-gradient(135deg, #1a1a1a, #333333);
    margin: 0;
    padding: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    min-height: 100vh;
    color: #d4af37; /* gold text default */
  }

  .container {
    background: linear-gradient(145deg, #222222, #111111);
    border-radius: 15px;
    box-shadow: 0 0 20px rgba(212, 175, 55, 0.8);
    padding: 0 30px 30px 30px;
    max-width: 400px;
    width: 90%;
    position: relative;
    overflow: hidden;
    color: #d4af37;
  }

  .container img {
    display: block;
    width: 100%;
    max-width: 250px;
    height: auto;
    margin: 0 auto;
    border-top-left-radius: 15px;
    border-top-right-radius: 15px;
    filter: drop-shadow(0 0 8px gold);
  }

  .container h4 {
    background: linear-gradient(90deg, gold, black, gray);
    color: #fff;
    padding: 10px 15px;
    border-radius: 8px;
    text-align: center;
    margin: 15px 0;
    box-shadow: 0 0 8px rgba(212, 175, 55, 0.7);
  }

  .form-group {
    margin-bottom: 15px;
    position: relative;
  }

  .form-group input {
    width: 100%;
    padding: 10px 35px 10px 35px;
    border: 1px solid #555;
    border-radius: 8px;
    outline: none;
    transition: 0.3s;
    box-sizing: border-box;
    background: #1a1a1a;
    color: #d4af37;
  }

  .form-group input::placeholder {
    color: #aaa;
  }

  .form-group input:focus {
    border-color: gold;
    box-shadow: 0 0 8px rgba(212, 175, 55, 0.8);
    background: #111;
    color: #ffd700;
  }

  .form-group .input-icon {
    position: absolute;
    left: 10px;
    top: 50%;
    transform: translateY(-50%);
    color: gold;
    pointer-events: none;
  }

  .form-group .toggle-password {
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-50%);
    cursor: pointer;
    color: #d4af37;
    opacity: 0.7;
    transition: opacity 0.3s;
  }

  .form-group .toggle-password:hover {
    opacity: 1;
  }

  .form-check {
    margin-bottom: 15px;
    color: #d4af37;
  }

  .btn {
    padding: 10px;
    width: 100%;
    margin-top: 10px;
    border: none;
    border-radius: 8px;
    background: linear-gradient(90deg, gold, #b8860b);
    color: #000;
    font-weight: bold;
    cursor: pointer;
    box-shadow: 0 3px 10px rgba(212, 175, 55, 0.7);
    transition: background 0.3s ease, color 0.3s ease;
  }

  .btn:hover {
    background: linear-gradient(90deg, #ffd700, #d4af37);
    color: #111;
  }

  .form-note {
    text-align: center;
    margin-top: 10px;
    color: #d4af37;
  }

  .preloader-bar {
    height: 5px;
    background: gold;
    animation: loading 2s infinite;
    border-radius: 0 0 8px 8px;
  }

  @keyframes loading {
    0% { width: 0; }
    50% { width: 50%; }
    100% { width: 100%; }
  }

  .page-loader {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(26, 26, 26, 0.95);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    display: none;
  }

  .spinner {
    width: 60px;
    height: 60px;
    border: 6px solid #555;
    border-top-color: gold;
    border-radius: 50%;
    animation: spin 1s linear infinite;
  }

  @keyframes spin {
    to {
      transform: rotate(360deg);
    }
  }
</style>

</head>

<body>
  <div class="container">
    <img src="images/logoc.png" alt="Logo">
    <div class="preloader-bar"></div>
    <h4> Admin Register</h4>

    <form onsubmit="showLoader()" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">
        
<div style="color:red; font-size:17px; text:align:center;margin-top:15px;"> 	
 <?php echo @$password_err;?>
 <?php echo @$phone_number_err;?>
  <?php echo @$confirm_password_err;?>
   <?php echo @$email_address_err;?>
   <?php //echo @$email_valid_error;?>
</div>


      <div class="form-group">
        <i class="fas fa-user input-icon"></i>
        <input type="text" name="first_name" placeholder="First Name" required>
      </div>
      <div class="form-group">
        <i class="fas fa-user input-icon"></i>
        <input type="text" name="last_name" placeholder="Last Name" required>
      </div>
      <div class="form-group">
        <i class="fas fa-phone input-icon"></i>
        <input type="number" name="phone_number" placeholder="Phone Number" required>
      </div>
      <div class="form-group">
        <i class="fas fa-envelope input-icon"></i>
        <input type="email" name="email_address" placeholder="Email Address" required>
      </div>

      <input type="hidden" name="my_sponsor" value="<?php echo empty($_GET['sponsor']) ? 'admin' : $_GET['sponsor']; ?>">

      <div class="form-group">
        <i class="fas fa-lock input-icon"></i>
        <input type="password" name="password" id="password" placeholder="Password" required>
        <i class="fas fa-eye toggle-password" onclick="togglePassword('password', this)"></i>
      </div>
      <div class="form-group">
        <i class="fas fa-lock input-icon"></i>
        <input type="password" name="confirm_password" id="confirm_password" placeholder="Confirm Password" required>
        <i class="fas fa-eye toggle-password" onclick="togglePassword('confirm_password', this)"></i>
      </div>

      <div class="form-check">
        <label><input type="checkbox"> Remember me</label>
      </div>

      <button type="submit" class="btn">Submit</button>

      <div class="form-note">
        <a href="https://rewardstream.com.ng/login.php">Already have an account? Log in</a>
      </div>
    </form>
  </div>

  <!-- Preloader Overlay -->
  <div class="page-loader" id="pageLoader">
    <div class="spinner"></div>
  </div>

  <script>
    function togglePassword(fieldId, icon) {
      const input = document.getElementById(fieldId);
      const isPassword = input.type === 'password';
      input.type = isPassword ? 'text' : 'password';
      icon.classList.toggle('fa-eye');
      icon.classList.toggle('fa-eye-slash');
    }

    function showLoader() {
      document.getElementById("pageLoader").style.display = "flex";
    }
  </script>
</body>
</html>