<?php
// Initialize the session
session_start();
 
// Check if the user is logged in, if not then redirect him/her to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}



include 'connect.php';
include 'menu.php';

// Pagination setup
$limit = 10;
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$start = ($page - 1) * $limit;

// Search setup
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$search_query = $search ? "WHERE package_name LIKE ?" : "";
$total_query = "SELECT COUNT(*) as total FROM packages $search_query";
$fetch_query = "SELECT * FROM packages $search_query ORDER BY id DESC LIMIT ?, ?";

// Count total
if ($search) {
    $stmt = $con->prepare($total_query);
    $like = "%$search%";
    $stmt->bind_param("s", $like);
} else {
    $stmt = $con->prepare($total_query);
}
$stmt->execute();
$result = $stmt->get_result();
$total = $result->fetch_assoc()['total'];
$total_pages = ceil($total / $limit);

// Fetch packages
if ($search) {
    $stmt = $con->prepare($fetch_query);
    $stmt->bind_param("sii", $like, $start, $limit);
} else {
    $stmt = $con->prepare($fetch_query);
    $stmt->bind_param("ii", $start, $limit);
}
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Package List</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  
  <!-- Bootstrap CSS -->
  <link
    href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css"
    rel="stylesheet"
  />
  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
  
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <style>
  body {
    background: linear-gradient(135deg, #1c1c1c, #2e2e2e);
    font-family: "Segoe UI", sans-serif;
    color: #d4af37;
  }
  .container {
    padding-top: 30px;
    max-width: 1200px;
    margin: 0 auto;
  }
  .card {
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(212, 175, 55, 0.3);
    background: linear-gradient(145deg, #3a3a3a, #2b2b2b);
    padding: 20px;
    color: #d4af37;
  }
  .table th, .table td {
    vertical-align: middle;
    border: 1px solid #555;
  }
  .table th {
    background: linear-gradient(to right, gold, black);
    color: #fff;
  }
  .btn-sm {
    padding: 4px 10px;
    font-size: 0.875rem;
    border-radius: 6px;
    font-weight: 600;
    cursor: pointer;
    background: linear-gradient(90deg, gold, black);
    color: #111;
    border: none;
    transition: background-color 0.3s ease;
  }
  .btn-sm:hover {
    background: gold;
    color: black;
  }
  .action-buttons a {
    margin-right: 5px;
  }
  .create-btn {
    margin-bottom: 15px;
    background: linear-gradient(90deg, gold, black);
    color: #111;
    font-weight: bold;
    padding: 8px 15px;
    border-radius: 8px;
    text-decoration: none;
    display: inline-block;
    box-shadow: 0 3px 8px rgba(212, 175, 55, 0.6);
    transition: background-color 0.3s ease;
  }
  .create-btn:hover {
    background: gold;
    color: black;
  }
</style>

</head>
<body>

<div class="container">
  <div class="card p-4">
    <h4 class="mb-3 text-primary">📦 All Package </h4>

    <!-- Search Form 
    <form method="GET" class="mb-3 row g-2 align-items-center">
      <div class="col-md-4 col-sm-12">
        <input
          type="text"
          name="search"
          class="form-control"
          placeholder="Search package..."
          value="<?= htmlspecialchars($search) ?>"
        />
      </div>
      <div class="col-auto">
        <button type="submit" class="btn btn-primary">🔍 Search</button>
      </div>
    </form>-->

    <!-- Create New Package Button with white plus icon -->
    <div class="create-btn">
      <a href="create_package.php" class="btn btn-primary">
        <i class="bi bi-plus-lg text-white me-1"></i> Create New Package
      </a>
    </div>

    <!-- Table -->
    <div class="table-responsive">
      <table class="table table-hover table-bordered align-middle text-center">
        <thead class="table-primary">
          <tr>
            <th>#</th>
            <th>Package Name</th>
            <th>Activation Amount</th>
            <th>Task Rate</th>
            <th>Task Limit</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($result->num_rows > 0): ?>
            <?php $sn = $start + 1; ?>
            <?php while ($row = $result->fetch_assoc()): ?>
              <tr>
                <td><?= $sn++ ?></td>
                <td><?= htmlspecialchars($row['package_name']) ?></td>
                <td>₦<?= number_format($row['activation_amount'], 2) ?></td>
                <td>₦<?= number_format($row['task_rate'], 2) ?></td>
                <td><?= $row['task_limit'] ?></td>
                <td class="action-buttons">
                  <a href="view_package.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-info text-white">View</a>
                  <a href="edit_package.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning text-white">Edit</a>
                  <a href="delete_package.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this package?')">Delete</a>
                </td>
              </tr>
            <?php endwhile; ?>
          <?php else: ?>
            <tr><td colspan="6" class="text-muted">No packages found.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <!-- Pagination -->
    <?php if ($total_pages > 1): ?>
      <nav>
        <ul class="pagination justify-content-center mt-3">
          <?php for ($i = 1; $i <= $total_pages; $i++): ?>
            <li class="page-item <?= $i == $page ? 'active' : '' ?>">
              <a class="page-link" href="?page=<?= $i ?>&search=<?= urlencode($search) ?>"><?= $i ?></a>
            </li>
          <?php endfor; ?>
        </ul>
      </nav>
    <?php endif; ?>

  </div>
</div>




</body>
</html>
