<?php
// Initialize the session
session_start();

// Check if the user is logged in, if not then redirect to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}

// Include config and connect files
require_once "config.php";
include('connect.php');
//include 'header.php';

// Handle approve/decline actions with password verification
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {
    $id = intval($_POST['id']);
    $action = $_POST['action'];
    $entered_password = $_POST['admin_password'];

    // Get admin details from session
    $admin_id = $_SESSION['id']; // assuming admin ID is stored in session
    $admin = mysqli_fetch_assoc(mysqli_query($con, "SELECT password FROM admin WHERE id='$admin_id'"));

    if ($admin && password_verify($entered_password, $admin['password'])) {
        // Fetch deposit details
        $req = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM deposits WHERE id='$id'"));
        if ($req) {
            $amount = floatval($req['amount']);
            $phone = mysqli_real_escape_string($con, $req['phone_number']);
            $current_status = strtolower($req['status']);

            if ($action == 'approve' && $current_status == 'pending') {
                mysqli_query($con, "UPDATE members SET main_wallet = main_wallet + $amount WHERE phone_number='$phone'");
                mysqli_query($con, "UPDATE deposits SET status='approved' WHERE id='$id'");
                $_SESSION['alert'] = "approved";
            } elseif ($action == 'decline' && $current_status == 'pending') {
                mysqli_query($con, "UPDATE deposits SET status='declined' WHERE id='$id'");
                $_SESSION['alert'] = "declined";
            } else {
                $_SESSION['alert'] = "processed";
            }
        }
    } else {
        $_SESSION['alert'] = "invalid_password";
    }

    // Redirect to same page to prevent form resubmit on refresh
    header("Location: ".$_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING']);
    exit;
}

// Search logic
$search = '';
$where = '1';
if (isset($_GET['search']) && !empty(trim($_GET['search']))) {
    $search = trim($_GET['search']);
    $where = "phone_number LIKE '%$search%'";
}

// Pagination logic
$per_page = 10;
$current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($current_page < 1) $current_page = 1;
$offset = ($current_page - 1) * $per_page;

// Get total count for pagination
$total_result = mysqli_query($con, "SELECT COUNT(*) FROM deposits WHERE $where");
$total_row = mysqli_fetch_row($total_result);
$total_pages = ceil($total_row[0] / $per_page);

// Fetch deposits for current page
$deposits = mysqli_query($con, "
    SELECT * FROM deposits
    WHERE $where
    ORDER BY date_submitted DESC
    LIMIT $offset, $per_page
");
?>

<?php if (isset($_SESSION['alert'])): ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
window.addEventListener('load', () => {
  let message = '';
  let icon = '';
  if ('<?= $_SESSION['alert'] ?>' === 'approved') {
    message = 'Deposit approved and wallet credited!';
    icon = 'success';
  } else if ('<?= $_SESSION['alert'] ?>' === 'declined') {
    message = 'Deposit declined.';
    icon = 'info';
  } else if ('<?= $_SESSION['alert'] ?>' === 'processed') {
    message = 'This request was already processed.';
    icon = 'warning';
  } else if ('<?= $_SESSION['alert'] ?>' === 'invalid_password') {
    message = 'Invalid password. Action not performed.';
    icon = 'error';
  }
  Swal.fire({
    icon: icon,
    title: message,
    confirmButtonText: 'OK'
  });
});
</script>
<?php unset($_SESSION['alert']); ?>
<?php endif; ?>


<!DOCTYPE html>
<html lang="en">
<head>
  <title>Admin - Deposit Approvals</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
  body {
    font-family: Arial, sans-serif;
    background: linear-gradient(135deg, #1c1c1c, #2e2e2e);
    margin: 0;
    color: #d4af37;
  }
  header {
    background: linear-gradient(to right, gold, black);
    color: #fff;
    padding: 1em;
    text-align: center;
    position: relative;
    box-shadow: 0 3px 8px rgba(0, 0, 0, 0.6);
  }
  .hamburger {
    position: absolute;
    left: 15px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 22px;
    cursor: pointer;
    color: gold;
  }
  .container {
    max-width: 1000px;
    margin: 20px auto;
    background: linear-gradient(145deg, #3a3a3a, #2b2b2b);
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 0 15px rgba(212, 175, 55, 0.5);
    color: #d4af37;
  }
  table {
    width: 100%;
    border-collapse: collapse;
    overflow-x: auto;
    display: block;
  }
  th, td {
    padding: 10px;
    border: 1px solid #555;
    text-align: center;
  }
  th {
    background: linear-gradient(to right, gold, black);
    color: #fff;
  }
  button {
    padding: 5px 10px;
    border: none;
    color: white;
    border-radius: 5px;
    cursor: pointer;
    font-weight: bold;
    box-shadow: 0 2px 5px rgba(212, 175, 55, 0.6);
    transition: background-color 0.3s ease;
  }
  .approve {
    background: linear-gradient(to right, #b8860b, #ffd700);
    color: #222;
  }
  .approve:hover {
    background: gold;
    color: black;
  }
  .decline {
    background: linear-gradient(to right, #660000, #a00000);
  }
  .decline:hover {
    background: #ff3333;
  }
  .status-approved {
    color: #b8860b;
    font-weight: bold;
  }
  .status-declined {
    color: #a00000;
    font-weight: bold;
  }
  .status-pending {
    color: #d4af37;
    font-weight: bold;
  }
  footer {
    background: linear-gradient(to right, black, gold);
    color: white;
    text-align: center;
    padding: 10px;
    position: fixed;
    bottom: 0;
    width: 100%;
    box-shadow: 0 -2px 10px rgba(212, 175, 55, 0.7);
  }
  #preloader {
    position: fixed;
    top: 0; left: 0; right: 0; bottom: 0;
    background: #1c1c1c;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
  }
  @media (max-width: 768px) {
    th, td {
      font-size: 14px;
    }
  }
</style>

</head>
<body>
<!--<div id="preloader"><i class="fas fa-spinner fa-spin fa-3x"></i></div>--->
<header>
  <div class="hamburger" onclick="toggleMenu()"><i class="fas fa-bars"></i></div>
  Admin - Deposit Approvals
</header>


<div class="mobile-menu" id="mobileMenu">
  <a href="dashboard.php" style="color:red"><i class="fas fa-home"></i> Dashboard</a>
</div>


<div class="container">
  <h2><i class="fas fa-money-check-alt"></i> Pending Deposit Requests</h2>

  <form method="GET" style="margin-bottom: 15px; text-align:center;">
    <input type="text" name="search" placeholder="Search by phone number" value="<?= htmlspecialchars($search) ?>">
    <button type="submit" style="color:white;background-color:blue;">Search</button>
  </form>

  <table>
    <thead>
      <tr>
        <th>User</th>
        <th>Amount</th>
        <th>Depositor</th>
        <th>Status</th>
        <th>Date</th>
        <th>Action</th>
      </tr>
    </thead>
    <tbody>
    <?php if (mysqli_num_rows($deposits) > 0): ?>
      <?php while ($d = mysqli_fetch_assoc($deposits)): ?>
      <tr>
        <td><?= htmlspecialchars($d['phone_number']) ?></td>
        <td>₦<?= number_format($d['amount'], 2) ?></td>
        <td><?= htmlspecialchars($d['depositor']) ?></td>
        <td class="status-<?= strtolower($d['status']) ?>"><?= ucfirst($d['status']) ?></td>
        <td><?= date("d M Y, h:i A", strtotime($d['date_submitted'])) ?></td>
        <td>
          <?php if ($d['status'] == 'pending'): ?>
            <button class="action-btn approve" data-id="<?= $d['id'] ?>" data-action="approve">Approve</button>
            <button class="action-btn decline" data-id="<?= $d['id'] ?>" data-action="decline">Decline</button>
          <?php else: echo "-"; endif; ?>
        </td>
      </tr>
      <?php endwhile; ?>
    <?php else: ?>
      <tr><td colspan="6">No records found.</td></tr>
    <?php endif; ?>
    </tbody>
  </table>

  <!-- Pagination -->
  <div class="pagination">
    <?php
    if ($total_pages > 1) {
        for ($i = 1; $i <= $total_pages; $i++) {
            if ($i == 1 || $i == $total_pages || abs($current_page - $i) <= 1) {
                echo '<a href="?page='.$i.'&search='.urlencode($search).'"'.($i == $current_page ? ' class="active"' : '').'>'.$i.'</a>';
            } elseif (abs($current_page - $i) == 2) {
                echo '<span>...</span>';
            }
        }
    }
    ?>
  </div>
</div>

<!-- SweetAlert for password input -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.querySelectorAll('.action-btn').forEach(btn => {
  btn.addEventListener('click', function(e) {
    e.preventDefault();
    const id = this.getAttribute('data-id');
    const action = this.getAttribute('data-action');

    Swal.fire({
      title: 'Enter Admin Password',
      input: 'password',
      inputPlaceholder: 'Enter your password',
      showCancelButton: true,
      confirmButtonText: 'Confirm',
      preConfirm: (password) => {
        if (!password) {
          Swal.showValidationMessage('Password is required');
        }
        return password;
      }
    }).then(result => {
      if (result.isConfirmed) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = `
          <input type="hidden" name="id" value="${id}">
          <input type="hidden" name="action" value="${action}">
          <input type="hidden" name="admin_password" value="${result.value}">
        `;
        document.body.appendChild(form);
        form.submit();
      }
    });
  });
});
</script>

<footer>
  &copy; <?= date("Y") ?> CashFunz
</footer>




</body>
</html>
