<?php
session_start();
include("connect.php");



$requests = mysqli_query($con, "SELECT * FROM withdrawal_requests ORDER BY request_date DESC");

$action_message = '';
$action_status = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {
  $id = $_POST['id'];
  $action = $_POST['action'];

  if ($action == 'approve') {
    mysqli_query($con, "UPDATE withdrawal_requests SET status='approved' WHERE id='$id'");
    $action_message = "Withdrawal approved successfully!";
    $action_status = "success";
  } elseif ($action == 'decline') {
    $req = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM withdrawal_requests WHERE id='$id'"));
    $amount = $req['amount'];
    $phone = $req['phone_number'];
    mysqli_query($con, "UPDATE members SET earning_wallet = earning_wallet + $amount WHERE phone_number='$phone'");
    mysqli_query($con, "UPDATE withdrawal_requests SET status='declined' WHERE id='$id'");
    $action_message = "Withdrawal declined and funds refunded.";
    $action_status = "success";
  }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>Admin Withdrawal Approvals</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    body { 
        font-family: Arial, sans-serif; 
        background: linear-gradient(135deg, #1c1c1c, #2e2e2e); 
        margin: 0; 
        color: #d4af37;
    }
    header {
        background: linear-gradient(to right, gold, black);
        color: white;
        padding: 1em; 
        text-align: center;
        position: relative;
        box-shadow: 0 3px 8px rgba(212, 175, 55, 0.7);
    }
    .hamburger { 
        position: absolute; 
        left: 15px; 
        top: 50%; 
        transform: translateY(-50%); 
        font-size: 20px; 
        cursor: pointer; 
        color: gold;
        text-shadow: 0 0 5px #ffd700;
    }
    .container {
        max-width: 1000px;
        margin: 30px auto;
        background: #2b2b2b;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(212, 175, 55, 0.4);
        color: #d4af37;
    }
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 1em;
        color: #d4af37;
    }
    th, td {
        border: 1px solid #555;
        padding: 10px;
        text-align: left;
        font-size: 14px;
    }
    th { 
        background: linear-gradient(90deg, gold, black);
        color: #fff; 
        text-shadow: 0 0 3px #ffd700;
    }
    td { 
        background: #1c1c1c; 
    }
    form { 
        display: inline; 
    }
    .status-pending { 
        color: orange; 
        font-weight: bold; 
    }
    .status-approved { 
        color: #32cd32; /* lime green for approved */
        font-weight: bold; 
    }
    .status-declined { 
        color: #ff4500; /* orange-red for declined */
        font-weight: bold; 
    }
    button {
        padding: 6px 12px;
        border: none;
        color: black;
        cursor: pointer;
        border-radius: 4px;
        font-size: 13px;
        font-weight: bold;
        background: linear-gradient(90deg, gold, black);
        box-shadow: 0 2px 6px rgba(212,175,55,0.7);
        transition: background 0.3s ease;
    }
    button:hover {
        background: gold;
        color: black;
        box-shadow: 0 3px 10px rgba(212,175,55,1);
    }
    .approve { 
        background: linear-gradient(90deg, #32cd32, #228b22);
        color: white;
    }
    .approve:hover {
        background: #228b22;
        box-shadow: 0 3px 10px rgba(34,139,34,1);
    }
    .decline { 
        background: linear-gradient(90deg, #ff4500, #b22222);
        color: white;
    }
    .decline:hover {
        background: #b22222;
        box-shadow: 0 3px 10px rgba(178,34,34,1);
    }
    footer {
        text-align: center;
        padding: 10px;
        background: linear-gradient(to right, black, gold);
        color: white;
        margin-top: 30px;
        box-shadow: 0 -3px 8px rgba(212, 175, 55, 0.7);
    }
    .table-responsive {
        overflow-x: auto;
    }
    #preloader {
        position: fixed;
        top: 0; left: 0; right: 0; bottom: 0;
        background: #1c1c1c;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 1000;
    }
</style>

</head>
<body>
<div id="preloader"><i class="fas fa-spinner fa-spin fa-3x text-primary"></i></div>

<header>
  <div class="hamburger"><i class="fas fa-bars"></i></div>
  Admin - Withdrawal Approvals
</header>

<div class="container">
  <h3><i class="fas fa-money-check-alt"></i> Pending Withdrawals</h3>
  <div class="table-responsive">
    <table>
      <thead>
        <tr>
          <th>User</th>
          <th>Amount</th>
          <th>Bank</th>
          <th>Account</th>
          <th>Status</th>
          <th>Requested On</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>
      <?php while ($r = mysqli_fetch_assoc($requests)) { ?>
        <tr>
          <td><?= $r['phone_number'] ?></td>
          <td>₦<?= number_format($r['amount'], 2) ?></td>
          <td><?= $r['bank_name'] ?></td>
          <td><?= $r['account_name'] ?> (<?= $r['account_number'] ?>)</td>
          <td class="status-<?= strtolower($r['status']) ?>"><?= ucfirst($r['status']) ?></td>
          <td><?= date('d M Y, h:i A', strtotime($r['request_date'])) ?></td>
          <td>
            <?php if ($r['status'] == 'pending') { ?>
              <form method="POST">
                <input type="hidden" name="id" value="<?= $r['id'] ?>">
                <button class="approve" name="action" value="approve"><i class="fas fa-check"></i> Approve</button>
                <button class="decline" name="action" value="decline"><i class="fas fa-times"></i> Decline</button>
              </form>
            <?php } else { echo "-"; } ?>
          </td>
        </tr>
      <?php } ?>
      </tbody>
    </table>
  </div>
</div>

<footer>
  &copy; <?= date('Y') ?> CashFunz Admin Panel
</footer>

<?php if ($action_message): ?>
<script>
  window.addEventListener('load', () => {
    Swal.fire({
      icon: '<?= $action_status ?>',
      title: 'Success',
      text: '<?= $action_message ?>',
      confirmButtonText: 'OK'
    });
  });
</script>
<?php endif; ?>

<script>
  window.addEventListener('load', () => {
    document.getElementById('preloader').style.display = 'none';
  });
</script>
</body>
</html>
