<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('connect.php');

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login.php");
    exit;
}

$phone_number = $_SESSION['phone_number'];
$message = "";
$message_type = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['package_id'])) {
    $package_id = intval($_POST['package_id']);
} elseif (isset($_GET['id'])) {
    $package_id = intval($_GET['id']);
} else {
    header("Location: dashboard.php");
    exit;
}

// Fetch selected package info
$package_result = mysqli_query($con, "SELECT * FROM packages WHERE id='$package_id'");
if (!$package_result || mysqli_num_rows($package_result) == 0) {
    $message = "Package not found.";
    $message_type = "error";
} else {
    $package = mysqli_fetch_assoc($package_result);
    $activation_amount = $package['activation_amount'];
    $new_level = $package['level'];
    $package_name = htmlspecialchars($package['package_name'], ENT_QUOTES);
    $duration_days = intval($package['duration']); // Assuming duration is number of days
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && empty($message)) {
    // Get existing user package if any
    $existing_query = mysqli_query($con, "SELECT * FROM user_packages WHERE phone_number='$phone_number'");
    $has_existing = mysqli_num_rows($existing_query) > 0;
    $current_level = 0;

    if ($has_existing) {
        $existing = mysqli_fetch_assoc($existing_query);
        $current_level = intval($existing['level']);
        $package_end_date_db = $existing['package_end_date'];
        $now = date('Y-m-d');

        if ($new_level == $current_level) {
            if ($package_end_date_db >= $now) {
                // Package still active
                $message = "You already have this package activated and it is not expired yet.";
                $message_type = "error";
            }
            // else: package expired, allow reactivation (no error)
        } elseif ($new_level < $current_level) {
            $message = "You cannot downgrade to a lower package.";
            $message_type = "error";
        }
        // If $new_level > $current_level, allow upgrade automatically
    }

    if (empty($message)) {
        $member_result = mysqli_query($con, "SELECT main_wallet FROM members WHERE phone_number='$phone_number'");
        if (!$member_result || mysqli_num_rows($member_result) == 0) {
            $message = "User account not found.";
            $message_type = "error";
        } else {
            $user = mysqli_fetch_assoc($member_result);
            $main_wallet = $user['main_wallet'];

            if ($main_wallet < $activation_amount) {
                $message = "Insufficient balance in your wallet.";
                $message_type = "error";
            } else {
                mysqli_begin_transaction($con);

                $deduct = mysqli_query($con, "UPDATE members SET main_wallet = main_wallet - $activation_amount WHERE phone_number='$phone_number'");

                // Calculate package end date based on duration (today + duration days)
                $package_end_date = date('Y-m-d', strtotime("+$duration_days days"));

                if ($has_existing) {
                    $update_package = mysqli_query($con, "UPDATE user_packages SET package_id='$package_id', level='$new_level', package_end_date='$package_end_date' WHERE phone_number='$phone_number'");
                } else {
                    $update_package = mysqli_query($con, "INSERT INTO user_packages (phone_number, package_id, level, package_end_date) VALUES ('$phone_number', '$package_id', '$new_level', '$package_end_date')");
                }

                if ($deduct && $update_package) {
                    // Fetch sponsor
                    $ref_query = mysqli_query($con, "SELECT sponsor_id FROM members WHERE phone_number='$phone_number'");
                    if ($ref_query && mysqli_num_rows($ref_query) > 0) {
                        $ref_data = mysqli_fetch_assoc($ref_query);
                        $sponsor_id = $ref_data['sponsor_id'];

                         if (!empty($sponsor_id)) {
                            $bonus = round($activation_amount * (30 / 100), 2);
                            mysqli_query($con, "UPDATE members SET earning_wallet = earning_wallet + $bonus WHERE member_id = '$sponsor_id'");
                            mysqli_query($con, "INSERT INTO referral_bonus (sponsor_id, member_phone, bonus_amount, date) VALUES ('$sponsor_id', '$phone_number', '$bonus', NOW())");
                        }
                    }

                    mysqli_commit($con);
                    $message = "Package activated successfully. ₦" . number_format($activation_amount) . " has been deducted from your wallet.";
                    $message_type = "success";
                } else {
                    mysqli_rollback($con);
                    $message = "An error occurred during package activation.";
                    $message_type = "error";
                }
            }
        }
    }
}
?>


<!-- HTML section starts -->
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Activate Package</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
  <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
 <style>
  body {
    font-family: 'Segoe UI', sans-serif;
    background: linear-gradient(135deg, #1a1a1a, #2e2e2e); /* dark gradient */
    margin: 0;
    padding: 0;
    color: #ddd; /* light gray for better contrast */
  }

  header {
    background: linear-gradient(90deg, #805c00, #bfa04a); /* rich gold gradient */
    color: #1a1a1a; /* dark text for contrast */
    padding: 15px 20px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    box-shadow: 0 3px 8px rgba(191,160,74,0.6);
  }

  header img {
    height: 45px;
  }

  nav {
    background: #121212; /* near black */
    padding: 10px 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #bfa04a; /* muted gold */
    box-shadow: inset 0 -2px 5px rgba(191,160,74,0.3);
  }

  .nav-links {
    display: flex;
    gap: 20px;
  }

  .nav-links a {
    color: #d4af37; /* gold */
    text-decoration: none;
    font-size: 18px;
    display: flex;
    align-items: center;
    transition: color 0.3s ease;
    font-weight: 600;
    text-shadow: 0 0 4px rgba(191,160,74,0.7);
  }

  .nav-links a:hover {
    color: #f0d86b; /* brighter gold */
    text-shadow: 0 0 8px rgba(255, 215, 0, 0.8);
  }

  .nav-links a i {
    margin-right: 6px;
    font-size: 20px;
  }

  .hamburger {
    display: none;
    font-size: 24px;
    cursor: pointer;
    color: #d4af37;
    text-shadow: 0 0 4px rgba(191,160,74,0.7);
  }

  @media (max-width: 768px) {
    .nav-links {
      display: none;
      flex-direction: column;
      width: 100%;
      background: #1a1a1a;
      box-shadow: 0 4px 10px rgba(191,160,74,0.4);
      border-radius: 0 0 10px 10px;
      padding: 15px 0;
    }
    .nav-links.active {
      display: flex;
    }
    .hamburger {
      display: block;
    }
  }

  .container {
    max-width: 600px;
    background: #2e2e2e; /* dark gray */
    padding: 30px;
    margin: 30px auto;
    border-radius: 12px;
    box-shadow: 0 0 20px rgba(191,160,74,0.6); /* golden glow */
    color: #eee;
  }

  h2 {
    text-align: center;
    font-size: 28px;
    color: #d4af37; /* gold */
    text-shadow: 0 0 10px #bfa04a;
  }

  .package-details p {
    font-size: 18px;
    margin: 12px 0;
    color: #bbb; /* softer gray */
  }

  .btn {
    display: block;
    width: 100%;
    padding: 14px;
    background: linear-gradient(90deg, #805c00, #bfa04a);
    color: #1a1a1a;
    border: none;
    border-radius: 8px;
    font-size: 18px;
    cursor: pointer;
    font-weight: 700;
    margin-top: 20px;
    box-shadow: 0 5px 15px rgba(191,160,74,0.7);
    transition: background 0.3s ease, box-shadow 0.3s ease;
    text-shadow: 0 0 4px rgba(191,160,74,0.7);
  }

  .btn:hover {
    background: linear-gradient(90deg, #d4af37, #f0d86b);
    box-shadow: 0 8px 20px rgba(255, 215, 0, 0.9);
  }

  .back-link {
    display: block;
    margin-top: 25px;
    text-align: center;
    font-size: 18px;
    color: #d4af37;
    text-decoration: none;
    font-weight: 600;
    transition: color 0.3s ease;
    text-shadow: 0 0 4px rgba(191,160,74,0.7);
  }

  .back-link:hover {
    color: #f0d86b;
    text-shadow: 0 0 8px rgba(255, 215, 0, 0.8);
  }

  footer {
    background: #1a1a1a;
    color: #bfa04a;
    text-align: center;
    padding: 15px;
    margin-top: 40px;
    box-shadow: inset 0 1px 5px rgba(191,160,74,0.4);
  }
</style>

</head>
<body>

<!---
<header>
  <img src="logoc.png" alt="Logo" />
  <div class="hamburger" onclick="toggleMenu()">
    <i class="fas fa-bars"></i>
  </div>
</header>
--->

<nav>
  <div class="nav-links" id="navLinks">
    <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
    <a href="#"><i class="fas fa-wallet"></i> Wallet</a>
    <a href="#"><i class="fas fa-gift"></i> Packages</a>
    <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
  </div>
</nav>

<div class="container">
  <h2><i class="fas fa-box-open"></i> Activate Package</h2>

  <?php if (!empty($message)): ?>
    <script>
      document.addEventListener('DOMContentLoaded', function () {
        Swal.fire({
          icon: '<?= $message_type ?>',
          title: '<?= $message_type === "success" ? "Success" : "Oops!" ?>',
          html: `<?= nl2br(htmlspecialchars($message)) ?>`,
          confirmButtonText: 'Go to Dashboard'
        }).then(() => {
          <?php if ($message_type === "success" || $message_type === "error"): ?>
            window.location.href = 'dashboard.php';
          <?php endif; ?>
        });
      });
    </script>
  <?php endif; ?>

  <?php if ($package && $message_type !== "success"): ?>
    <div class="package-details">
      <p style="color: #fff; background: linear-gradient(90deg, gold, black, gray); padding:8px; border-radius:6px;"><strong><i class="fas fa-box"></i> Package Name:</strong> <?= $package_name ?></p>
      <p><strong><i class="fas fa-money-bill-wave"></i> Activation Fee:</strong> ₦<?= number_format($activation_amount) ?></p>
      <p><strong><i class="fas fa-tasks"></i> Daily Question Limit:</strong> <?= $package['task_limit'] ?></p>
      <p><strong><i class="fas fa-coins"></i> Daily Earning:</strong> ₦<?= number_format($package['task_limit'] * $package['task_rate']) ?></p>
      <p><strong><i class="fas fa-coins"></i> Duration:</strong> <?= $package['duration']?>-Days</p>
    </div>

    <form method="POST">
      <input type="hidden" name="package_id" value="<?= $package_id ?>" />
      <button type="submit" class="btn"><i class="fas fa-check-circle" style="color: #fff; background: linear-gradient(90deg, gold, black, gray); padding:8px; border-radius:6px;"></i> Activate Now</button>
    </form>
  <?php endif; ?>

  <a href="dashboard.php" class="back-link"><i class="fas fa-arrow-left"></i> Back to Dashboard</a>
</div>

<footer>
  &copy; <?= date('Y') ?> CashFunz. All rights reserved.
</footer>

<script>
function toggleMenu() {
  document.getElementById("navLinks").classList.toggle("active");
}
</script>
</body>
</html>